<?php
/**
 * Portfolio Content Template
 *
 * @package thimpress
 * @version 2.0.0
 */

defined('ABSPATH') || exit;

global $post, $portfolio_data;

// Column configuration
$column = 3;
$column_classes = array(
    1 => 'one-col',
    2 => 'two-col',
    3 => 'three-col',
    4 => 'four-col',
    5 => 'five-col'
);
$class_column = $column_classes[$column] ?? 'three-col';

// Get post data
$post_id = get_the_ID();
$post_title = get_the_title($post_id);
$post_permalink = get_permalink($post_id);

// Get portfolio categories
$item_cats = get_the_terms($post_id, 'portfolio_category');
$item_classes = '';
if ($item_cats && !is_wp_error($item_cats)) {
    $item_classes = implode(' ', array_map(function($cat) {
        return urldecode($cat->slug);
    }, $item_cats));
}

// Get image dimensions
$dimensions = isset($portfolio_data['thim_portfolio_option_dimensions']) ? $portfolio_data['thim_portfolio_option_dimensions'] : array();
$w = isset($dimensions['width']) ? $dimensions['width'] : 480;
$h = isset($dimensions['height']) ? $dimensions['height'] : 320;

// Get images
$image_id = get_post_thumbnail_id($post_id);
$imgurl = wp_get_attachment_image_src($image_id, array($w, $h));
$image_crop = $imgurl ? $imgurl[0] : '';

$imgurl_popup = wp_get_attachment_image_src($image_id, array(800, 640));
$image_popup = $imgurl_popup ? $imgurl_popup[0] : '';

// Build category links
$cat_links = '';
if ($item_cats && !is_wp_error($item_cats)) {
    $cat_links = implode(', ', array_map(function($term) {
        return '<a href="' . esc_url(get_term_link($term)) . '">' . esc_html($term->name) . '</a>';
    }, $item_cats));
}
?>

<li class="element-item <?php echo esc_attr($item_classes . ' item_portfolio ' . $class_column); ?>">
    <div class="portfolio-image">
        <img src="<?php echo esc_url($image_crop); ?>" alt="<?php echo esc_attr($post_title); ?>" title="<?php echo esc_attr($post_title); ?>" />
        <div class="portfolio-hover">
            <div class="thumb-bg">
                <div class="mask-content">
                    <div class="popup">
                        <a class="view-gallery" href="<?php echo esc_url($image_popup); ?>">
                            <i class="ion-android-add"></i>
                        </a>
                    </div>
                    <div class="info">
                        <h3>
                            <a href="<?php echo esc_url($post_permalink); ?>" title="<?php echo esc_attr($post_title); ?>">
                                <?php echo esc_html($post_title); ?>
                            </a>
                        </h3>
                        <?php if ($cat_links) : ?>
                            <div class="cat_portfolio"><?php echo $cat_links; ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</li>