<?php

if (empty(get_theme_mod('event_group_sharing'))) {
	$class = 'no-social';
} else {
	$class = 'has-social';
}

?>

<article id="tp_event-<?php the_ID(); ?>" <?php post_class('tp_single_event'); ?>>
	<div class="tp_single_event-thumbnail">
		<?php
		/**
		 * tp_event_single_event_thumbnail hook
		 */
		do_action('tp_event_single_event_thumbnail');
		/**
		 * tp_event_loop_event_countdown hook
		 */
		do_action('tp_event_loop_event_countdown');

		?>
	</div>
	<div class="summary entry-summary <?php echo esc_attr($class) ?>">

		<?php if (!empty(get_theme_mod('event_group_sharing'))) { ?>
			<div class="sticky-sidebar">
				<?php thim_social_share('event_'); ?>
			</div>
		<?php }; ?>

		<div class="entry-right">
			<?php
			/**
			 * tp_event_before_single_event hook
			 *
			 */
			do_action('tp_event_before_single_event');
			?>
			<div class="tp-single-event-info">
				<?php
				$time_from   = get_post_meta(get_the_ID(), 'tp_event_date_start', true) ? strtotime(get_post_meta(get_the_ID(), 'tp_event_date_start', true)) : time();
				$time_finish = get_post_meta(get_the_ID(), 'tp_event_date_end', true) ? strtotime(get_post_meta(get_the_ID(), 'tp_event_date_end', true)) : time();
				$time_start  = wpems_event_start(get_option('time_format'));
				$time_end    = wpems_event_end(get_option('time_format'));
				$location    = get_post_meta(get_the_ID(), 'tp_event_location', true) ? get_post_meta(get_the_ID(), 'tp_event_location', true) : '';
				$flap = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0609 15.2155C13.1409 15.6491 14.2536 16.0909 15.6364 16.0909C18.2955 16.0909 19.31 15.2073 19.49 15.0355C19.6373 14.88 19.7273 14.6755 19.7273 14.4545V4.63636C19.7273 4.31727 19.5309 4.03909 19.2364 3.9C18.95 3.76909 18.5982 3.82636 18.3527 4.03909C18.3445 4.04727 17.6327 4.63636 15.6364 4.63636C14.5686 4.63636 13.6551 4.27097 12.6775 3.87992L12.6664 3.87545C11.5864 3.44182 10.4736 3 9.09091 3C6.43182 3 5.41727 3.88364 5.23727 4.05545C5.09 4.21091 5 4.41545 5 4.63636V14.4545C5 14.4545 5 14.4546 5 14.4545V20.1818C5 20.6318 5.36818 21 5.81818 21C6.26818 21 6.63636 20.6318 6.63636 20.1818V14.8945C6.99659 14.7175 7.75701 14.4545 9.09091 14.4545C10.1587 14.4545 11.0721 14.8199 12.0498 15.211L12.0609 15.2155ZM12.6664 13.6936C11.5864 13.26 10.4736 12.8182 9.09091 12.8182C8.02727 12.8182 7.22545 12.9573 6.63636 13.1373V5.07818C6.99636 4.89818 7.75727 4.63636 9.09091 4.63636C10.1587 4.63636 11.0721 5.00176 12.0498 5.39281L12.0609 5.39727C13.1409 5.83091 14.2536 6.27273 15.6364 6.27273C16.7 6.27273 17.5018 6.13364 18.0909 5.95364V14.0127C17.7309 14.1927 16.97 14.4545 15.6364 14.4545C14.5686 14.4545 13.6551 14.0891 12.6775 13.6981L12.6664 13.6936Z" fill="white"/>
					</svg>
					';
				?>
				<div class="row">
					<div class="tp-info-box col-sm-4">
						<h4 class="heading">
							<i class="icon-ion-clock1"></i><?php esc_html_e('Start Time', 'course-builder'); ?>
						</h4>
						<p><?php printf('%s - %s1', $time_start, date_i18n(get_option('date_format'), $time_from)); ?></p>
					</div>
					<div class="tp-info-box col-sm-4">
						<h4 class="heading">
							<?php echo $flap; ?><?php esc_html_e('Finish Time', 'course-builder'); ?>
						</h4>
						<p><?php printf('%s - %s1', $time_end, date_i18n(get_option('date_format'), $time_finish)); ?></p>
					</div>
					<?php if ($location) { ?>
						<div class="tp-info-box col-sm-4">
							<h4 class="heading">
								<i class="icon-ion-map-pin"></i><?php esc_html_e('Address', 'course-builder'); ?>
							</h4>
							<p><?php echo esc_html($location); ?></p>
						</div>
					<?php } ?>
				</div>
			</div>
			<?php
			/**
			 * tp_event_single_event_content hook
			 */
			do_action('tp_event_single_event_content');
			$view_map    = get_post_meta(get_the_ID(), 'tp_event_iframe', true) ? get_post_meta(get_the_ID(), 'tp_event_iframe', true) : '';
			if(!empty($view_map)){
				echo '<div class="tp-single-event-map">';
				echo $view_map;
				echo '</div>';
			}

			/**
			 * tp_event_loop_event_location hook
			 */
			do_action('tp_event_loop_event_location');

			?>
		</div>
	</div><!-- .summary -->


</article><!-- #product-<?php the_ID(); ?> -->