<?php
/**
* Load more button ajax class
*/
if ( ! class_exists( 'CozyStay_Ajax_Load_More' ) ) {
 	class CozyStay_Ajax_Load_More {
		// Construct function
		public function __construct() {
			add_action( 'rest_api_init', array( $this, 'load_handler' ) );
			add_action( 'cozystay_pre_ajax_handler', array( $this, 'pre_ajax_start' ), 1 );
		}
		/**
		* Load ajax handler if ajax request received
		*/
		public function load_handler() {
			register_rest_route( 'cozystay/v1', '/load_more/(?P<nonce>.+)', array(
				'methods' 	=> 'POST',
				'permission_callback' => '__return_true',
				'callback' 	=> array( $this, 'ajax_handler' )
			) );
		}
		/**
		* Pre ajax start
		*/
		public function pre_ajax_start() {
			$this->load_files();
			add_filter( 'cozystay_get_current_page_layout', array( $this, 'set_ajax_page_layout' ), 99999 );
            do_action( 'cozystay_image_loading_attributes' );
		}
		/**
		* Set page layout for ajax handler
		*/
		public function set_ajax_page_layout( $layout ) {
			if ( isset( $_REQUEST[ 'settings' ] ) && is_string( $_REQUEST[ 'settings' ] ) ) {
				$args = sanitize_text_field( wp_unslash( $_REQUEST[ 'settings' ] ) );
				$args = json_decode( $args, true );
				$layout = isset( $args[ 'page_layout' ] ) ? $args[ 'page_layout' ] : '';
			} else {
				$layout = 'with-sidebar-right';
			}
			return $layout;
		}
		/**
		* Ajax request handler
		*/
		public function ajax_handler( $data ) {
			if ( isset( $data[ 'settings' ], $data[ 'query' ] ) && is_string( $data[ 'settings' ] ) && is_string( $data[ 'query' ] ) ) { 
				$settings = sanitize_text_field( wp_unslash( $data[ 'settings' ] ) );
				$settings = json_decode( $settings, true );
				$query = sanitize_text_field( wp_unslash( $data[ 'query' ] ) );
				$query = json_decode( $query, true ); 

				if ( isset( $settings[ 'archive_page' ], $query[ 'paged' ] ) ) {
					$paged = max( 1, intval( $query[ 'paged' ] ) );
					$archive_page = $settings[ 'archive_page' ];
					do_action( 'cozystay_pre_ajax_handler', $archive_page );

					if ( isset( $settings[ 'render_room_list' ] ) && ( 'yes' == $settings[ 'render_room_list' ] ) ) {
						do_action( 'loftocean_ajax_room_load_more', $query, $settings );
						wp_die();
					}

					query_posts( apply_filters( 'cozystay_ajax_handler_query_args', $query, $settings ) ); 
					global $wp_query;
					$results = array();
					if ( have_posts() ) {
	                    $is_post_archive = ! empty( $archive_page ) && ( 'archive' != $archive_page );
						if ( $is_post_archive ) {
	                        $layout = isset( $settings[ 'layout' ] ) ? $settings[ 'layout' ] : 'list';
	                        $post_list_args = array(
								'layout' => $layout,
								'columns' => isset( $settings[ 'columns' ] ) ? $settings[ 'columns' ] : '',
								'post_meta'	=> $settings[ 'post_meta' ],
								'page_layout' => isset( $settings[ 'page_layout' ] ) ? $settings[ 'page_layout' ] : ''
							);
							do_action( 'cozystay_start_post_list_loop', $post_list_args );
						} 
						add_filter( 'post_class' ,array( $this, 'add_post_class' ) );
						while( have_posts() ) {
							the_post();
							ob_start();
							if ( $is_post_archive ) {
								get_template_part( 'template-parts/content/content', $layout );
							} else {
								do_action( 'loftocean_ajax_the_list_content', $settings );
							}
							$results[] = ob_get_clean();
						}
						if ( $is_post_archive ) {
							do_action( 'cozystay_end_post_list_loop' );
						} 
						ob_start();
						cozystay_list_pagination();
						$nav = ob_get_clean();
						wp_reset_postdata();
						$more = ( $paged < $wp_query->max_num_pages );
						wp_reset_query();
						wp_send_json_success( array(
							'more' => $more,
							'items' => $results,
							'nav' => '',
						) );
					} else {
						ob_start();
						get_template_part( 'template-parts/content/content-none', $archive_page );
						$results[] = ob_get_clean();
						wp_send_json_success( array(
							'more' => false,
							'nav' => '',
							'items' => $results
						) );
					}
				}
			}
			wp_send_json_error();
		}
		/**
		* Load required files
		*/
		protected function load_files() {
			require_once COZYSTAY_THEME_INC . 'utils/class-utils-sanitize.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
			require_once COZYSTAY_THEME_INC . 'front/functions-template.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
			require_once COZYSTAY_THEME_INC . 'front/class-front-archive.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
			require_once COZYSTAY_THEME_INC . 'front/class-front-metas-cache.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
		}
		/**
		* Add classname post to class list
		*/
		public function add_post_class( $class ) {
			array_push( $class, 'post' );
			return $class;
		}
 	}
	new CozyStay_Ajax_Load_More();
}
