<?php
if ( ! class_exists( 'CozyStay_Front_Rooms' ) ) {
	class CozyStay_Front_Rooms {
		/**
		* Number current post id
		*/
		protected $current_post_id = false;
		/**
		* Construct function
		*/
		public function __construct() {
			add_action( 'template_redirect', array( $this, 'init_hooks' ), 999 );
		}
		/**
		* Init hooks
		*/
		public function init_hooks() {
			if ( apply_filters( 'loftocean_is_single_room', false ) ) {
				$this->current_post_id = get_queried_object_id();
				$show_site_header = 'on' != get_post_meta( $this->current_post_id, 'cozystay_single_room_hide_site_header', true );
				add_filter( 'cozystay_show_site_header', $show_site_header ? '__return_true' : '__return_false', 9999 );

				if ( 'custom' === cozystay_get_theme_mod( 'cozystay_rooms_single_site_header' ) ) { 
					add_filter( 'cozystay_is_custom_site_header', '__return_true', 99 );
					add_filter( 'cozystay_site_header_custom_block', array( $this, 'get_single_room_global_site_header' ), 9999 );
					add_filter( 'cozystay_sticky_site_header_custom_block', array( $this, 'get_single_room_global_sticky_site_header' ), 9999, 1 );
				}

				if ( 'custom' == get_post_meta( $this->current_post_id, 'cozystay_single_room_site_header_source', true ) ) {
					add_filter( 'cozystay_is_custom_site_header', '__return_true', 99999 );
					add_filter( 'cozystay_site_header_custom_block', array( $this, 'custom_site_header' ), 99999, 1 );
					add_filter( 'cozystay_sticky_site_header_custom_block', array( $this, 'custom_sticky_site_header' ), 99999, 1 );
				}
			}
		}
		/**
		* Get global custom site header
		*/
		public function get_single_room_global_site_header( $site_header ) {
			$custom_site_header = cozystay_get_theme_mod( 'cozystay_rooms_single_custom_site_header' );
			return empty( $custom_site_header ) ? $site_header : $custom_site_header;
		}
		/**
		* Get gloabl custom sticky site header
		*/
		public function get_single_room_global_sticky_site_header( $site_header ) {
			$custom_site_header = cozystay_get_theme_mod( 'cozystay_rooms_single_custom_sticky_site_header' );
			return empty( $custom_site_header ) ? $site_header : $custom_site_header;
		}
		/**
		* Check single site header custom block setting
		*/
		public function custom_site_header( $custom_block ) {
			if ( false !== $this->current_post_id ) {
				$meta_name = 'cozystay_single_room_custom_site_header';
				$meta_value = get_post_meta( $this->current_post_id, $meta_name, true );
				if ( ! empty( $meta_value ) && cozystay_does_item_exist( $meta_value ) ) {
					return $meta_value;
				}
			}
			return $custom_block;
		}
		/**
		* Check single site header custom block setting
		*/
		public function custom_sticky_site_header( $custom_block ) {
			if ( false !== $this->current_post_id ) {
				$meta_name = 'cozystay_single_room_custom_sticky_site_header';
				$meta_value = get_post_meta( $this->current_post_id, $meta_name, true );
				if ( ! empty( $meta_value ) && cozystay_does_item_exist( $meta_value ) ) {
					return $meta_value;
				}
			}
			return $custom_block;
		}
		/**
		* Custom site footer main
		*/
		public function custom_site_footer_main( $custom_block ) {
			if ( false !== $this->current_post_id ) {
				$meta_value = get_post_meta( $this->current_post_id, 'cozystay_single_custom_site_footer_main', true );
				if ( ! empty( $meta_value ) && cozystay_does_item_exist( $meta_value ) ) {
					return $meta_value;
				}
			}
			return $custom_block;
		}
		/**
		* Custom site footer above
		*/
		public function custom_site_footer_above( $custom_block ) {
			if ( false !== $this->current_post_id ) {
				$meta_value = get_post_meta( $this->current_post_id, 'cozystay_single_custom_site_footer_above', true );
				if ( ! empty( $meta_value ) && cozystay_does_item_exist( $meta_value ) ) {
					return $meta_value;
				}
			}
			return $custom_block;
		}
	}
	new CozyStay_Front_Rooms();
}
