<?php 
	$prev_label = esc_html__( 'Prev', 'cozystay' );
	$next_label = esc_html__( 'Next', 'cozystay' );
	$prev_link 	= get_previous_posts_link( $prev_label );
	$next_link 	= get_next_posts_link( $next_label );

	if ( ! empty( $prev_link) || ! empty( $next_link ) ) : ?>
		<nav class="navigation pagination">
			<div class="pagination-container with-page-numbers">
				<h2 class="screen-reader-text"><?php esc_html_e( 'Posts navigation', 'cozystay' ); ?></h2>
				<?php if ( empty( $prev_link ) ) : ?>
					<span class="prev page-numbers"><?php esc_html_e( 'Prev', 'cozystay' ); ?> </span>
				<?php else: ?>
					<?php previous_posts_link( $prev_label ); ?>
				<?php endif; ?>
				<?php echo paginate_links( array( 'prev_next' => false, 'type' => 'plain' ) ); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped ?>
				<?php if ( empty( $next_link ) ) : ?>
					<span class="next page-numbers"> <?php esc_html_e( 'Next', 'cozystay' ); ?></span>
				<?php else: ?>
					<?php next_posts_link( $next_label ); ?>
				<?php endif; ?>
			</div>
		</nav> <?php
	endif;