<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WPBakery Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$crown_art_content = '';
$crown_art_blog_archive_mask = '%%CONTENT%%';
$crown_art_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $crown_art_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($crown_art_content = apply_filters('the_content', get_the_content())) != '') {
		if (($crown_art_pos = strpos($crown_art_content, $crown_art_blog_archive_mask)) !== false) {
			$crown_art_content = preg_replace('/(\<p\>\s*)?'.$crown_art_blog_archive_mask.'(\s*\<\/p\>)/i', $crown_art_blog_archive_subst, $crown_art_content);
		} else
			$crown_art_content .= $crown_art_blog_archive_subst;
		$crown_art_content = explode($crown_art_blog_archive_mask, $crown_art_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) crown_art_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$crown_art_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$crown_art_args = crown_art_query_add_posts_and_cats($crown_art_args, '', crown_art_get_theme_option('post_type'), crown_art_get_theme_option('parent_cat'));
$crown_art_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($crown_art_page_number > 1) {
	$crown_art_args['paged'] = $crown_art_page_number;
	$crown_art_args['ignore_sticky_posts'] = true;
}
$crown_art_ppp = crown_art_get_theme_option('posts_per_page');
if ((int) $crown_art_ppp != 0)
	$crown_art_args['posts_per_page'] = (int) $crown_art_ppp;
// Make a new query
query_posts( $crown_art_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($crown_art_content) && count($crown_art_content) == 2) {
	set_query_var('blog_archive_start', $crown_art_content[0]);
	set_query_var('blog_archive_end', $crown_art_content[1]);
}

get_template_part('index');
?>