<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_blog_style = explode('_', crown_art_get_theme_option('blog_style'));
$crown_art_columns = empty($crown_art_blog_style[1]) ? 1 : max(1, $crown_art_blog_style[1]);
$crown_art_expanded = !crown_art_sidebar_present() && crown_art_is_on(crown_art_get_theme_option('expand_content'));
$crown_art_post_format = get_post_format();
$crown_art_post_format = empty($crown_art_post_format) ? 'standard' : str_replace('post-format-', '', $crown_art_post_format);
$crown_art_animation = crown_art_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($crown_art_columns).' post_format_'.esc_attr($crown_art_post_format) ); ?>
	<?php echo (!crown_art_is_off($crown_art_animation) ? ' data-animation="'.esc_attr(crown_art_get_animation_classes($crown_art_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($crown_art_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	crown_art_show_post_featured( array(
											'class' => $crown_art_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => crown_art_get_thumb_size(
																	strpos(crown_art_get_theme_option('body_style'), 'full')!==false
																		? ( $crown_art_columns > 1 ? 'huge' : 'original' )
																		: (	$crown_art_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('crown_art_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('crown_art_action_before_post_meta'); 

			// Post meta
			$crown_art_components = crown_art_is_inherit(crown_art_get_theme_option_from_meta('meta_parts')) 
										? 'categories,date'.($crown_art_columns < 3 ? ',counters' : '').($crown_art_columns == 1 ? ',edit' : '')
										: crown_art_array_get_keys_by_value(crown_art_get_theme_option('meta_parts'));
			$crown_art_counters = crown_art_is_inherit(crown_art_get_theme_option_from_meta('counters')) 
										? 'comments'
										: crown_art_array_get_keys_by_value(crown_art_get_theme_option('counters'));
			$crown_art_post_meta = empty($crown_art_components) 
										? '' 
										: crown_art_show_post_meta(apply_filters('crown_art_filter_post_meta_args', array(
                                                'components' => 'date,counters',
                                                'counters' => 'comments',
												'seo' => false,
												'echo' => false
												), $crown_art_blog_style[0], $crown_art_columns)
											);
			crown_art_show_layout($crown_art_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$crown_art_show_learn_more = !in_array($crown_art_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($crown_art_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($crown_art_post_format == 'quote') {
					if (($quote = crown_art_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						crown_art_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($crown_art_post_format, array('link', 'aside', 'status', 'quote'))) {
				crown_art_show_layout($crown_art_post_meta);
			}
			// More button
			if ( $crown_art_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'crown-art'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>