<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_post_format = get_post_format();
$crown_art_post_format = empty($crown_art_post_format) ? 'standard' : str_replace('post-format-', '', $crown_art_post_format);
$crown_art_animation = crown_art_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($crown_art_post_format) ); ?>
	<?php echo (!crown_art_is_off($crown_art_animation) ? ' data-animation="'.esc_attr(crown_art_get_animation_classes($crown_art_animation)).'"' : ''); ?>
	><?php

	// Featured image
	crown_art_show_post_featured(array( 'thumb_size' => crown_art_get_thumb_size( strpos(crown_art_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));

	// Title and post meta
	if (get_the_title() != '') {
		?><div class="post_header entry-header"><?php

            crown_art_show_post_meta(apply_filters('crown_art_filter_post_meta_args', array(
                    'components' => 'date',
                    'counters' => '',
                    'seo' => false
                ), 'excerpt', 1)
            );

			do_action('crown_art_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );

			do_action('crown_art_action_before_post_meta'); 

			?></div><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if (crown_art_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'crown-art' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'crown-art' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$crown_art_show_learn_more = !in_array($crown_art_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($crown_art_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($crown_art_post_format == 'quote') {
					if (($quote = crown_art_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						crown_art_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
            // Post meta
            $crown_art_components = crown_art_is_inherit(crown_art_get_theme_option_from_meta('meta_parts'))
                ? 'categories,counters,edit'
                : crown_art_array_get_keys_by_value(crown_art_get_theme_option('meta_parts'));
            $crown_art_counters = crown_art_is_inherit(crown_art_get_theme_option_from_meta('counters'))
                ? 'views,likes,comments'
                : crown_art_array_get_keys_by_value(crown_art_get_theme_option('counters'));

            if (!empty($crown_art_components))
                crown_art_show_post_meta(apply_filters('crown_art_filter_post_meta_args', array(
                        'components' => $crown_art_components,
                        'counters' => $crown_art_counters,
                        'seo' => false
                    ), 'excerpt', 1)
                );

		}
	?></div><!-- .entry-content -->
</article>