<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_blog_style = explode('_', crown_art_get_theme_option('blog_style'));
$crown_art_columns = empty($crown_art_blog_style[1]) ? 2 : max(2, $crown_art_blog_style[1]);
$crown_art_post_format = get_post_format();
$crown_art_post_format = empty($crown_art_post_format) ? 'standard' : str_replace('post-format-', '', $crown_art_post_format);
$crown_art_animation = crown_art_get_theme_option('blog_animation');
$crown_art_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($crown_art_columns).' post_format_'.esc_attr($crown_art_post_format) ); ?>
	<?php echo (!crown_art_is_off($crown_art_animation) ? ' data-animation="'.esc_attr(crown_art_get_animation_classes($crown_art_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($crown_art_image[1]) && !empty($crown_art_image[2])) echo intval($crown_art_image[1]) .'x' . intval($crown_art_image[2]); ?>"
	data-src="<?php if (!empty($crown_art_image[0])) echo esc_url($crown_art_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$crown_art_image_hover = 'icon';
	if (in_array($crown_art_image_hover, array('icons', 'zoom'))) $crown_art_image_hover = 'dots';
	$crown_art_components = crown_art_is_inherit(crown_art_get_theme_option_from_meta('meta_parts')) 
								? 'categories,date,counters,share'
								: crown_art_array_get_keys_by_value(crown_art_get_theme_option('meta_parts'));
	$crown_art_counters = crown_art_is_inherit(crown_art_get_theme_option_from_meta('counters')) 
								? 'comments'
								: crown_art_array_get_keys_by_value(crown_art_get_theme_option('counters'));
	crown_art_show_post_featured(array(
		'hover' => $crown_art_image_hover,
		'thumb_size' => crown_art_get_thumb_size( strpos(crown_art_get_theme_option('body_style'), 'full')!==false || $crown_art_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. (!empty($crown_art_components)
										? crown_art_show_post_meta(apply_filters('crown_art_filter_post_meta_args', array(
											'components' => $crown_art_components,
											'counters' => $crown_art_counters,
											'seo' => false,
											'echo' => false
											), $crown_art_blog_style[0], $crown_art_columns))
										: '')
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'crown-art') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>