<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_blog_style = explode('_', crown_art_get_theme_option('blog_style'));
$crown_art_columns = empty($crown_art_blog_style[1]) ? 2 : max(2, $crown_art_blog_style[1]);
$crown_art_post_format = get_post_format();
$crown_art_post_format = empty($crown_art_post_format) ? 'standard' : str_replace('post-format-', '', $crown_art_post_format);
$crown_art_animation = crown_art_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($crown_art_columns).' post_format_'.esc_attr($crown_art_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!crown_art_is_off($crown_art_animation) ? ' data-animation="'.esc_attr(crown_art_get_animation_classes($crown_art_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$crown_art_image_hover = crown_art_get_theme_option('image_hover');
	// Featured image
	crown_art_show_post_featured(array(
		'thumb_size' => crown_art_get_thumb_size(strpos(crown_art_get_theme_option('body_style'), 'full')!==false || $crown_art_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $crown_art_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $crown_art_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>