<?php
/**
 * The default template to display the content of the single post, page or attachment
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'post_item_single post-excerpt-single post_type_'.esc_attr(get_post_type())
												. ' post_format_'.esc_attr(str_replace('post-format-', '', get_post_format())) 
												. ' itemscope'
												); ?>
		itemscope itemtype="//schema.org/<?php echo esc_attr(is_single() ? 'BlogPosting' : 'Article'); ?>">
	<?php
	// Structured data snippets
	if (crown_art_is_on(crown_art_get_theme_option('seo_snippets'))) {
		?>
		<div class="structured_data_snippets">
			<meta itemprop="headline" content="<?php the_title_attribute(); ?>">
			<meta itemprop="datePublished" content="<?php echo esc_attr(get_the_date('Y-m-d')); ?>">
			<meta itemprop="dateModified" content="<?php echo esc_attr(get_the_modified_date('Y-m-d')); ?>">
			<meta itemscope itemprop="mainEntityOfPage" itemType="//schema.org/WebPage" itemid="<?php echo esc_url(get_the_permalink()); ?>" content="<?php the_title_attribute(); ?>"/>
			<div itemprop="publisher" itemscope itemtype="//schema.org/Organization">
				<div itemprop="logo" itemscope itemtype="//schema.org/ImageObject">
					<?php 
					$crown_art_logo_image = crown_art_get_retina_multiplier(2) > 1 
										? crown_art_get_theme_option( 'logo_retina' )
										: crown_art_get_theme_option( 'logo' );
					if (!empty($crown_art_logo_image)) {
						$crown_art_attr = crown_art_getimagesize($crown_art_logo_image);
						?>
						<img itemprop="url" src="<?php echo esc_url($crown_art_logo_image); ?>">
						<meta itemprop="width" content="<?php echo esc_attr($crown_art_attr[0]); ?>">
						<meta itemprop="height" content="<?php echo esc_attr($crown_art_attr[1]); ?>">
						<?php
					}
					?>
				</div>
				<meta itemprop="name" content="<?php echo esc_attr(get_bloginfo( 'name' )); ?>">
				<meta itemprop="telephone" content="">
				<meta itemprop="address" content="">
			</div>
		</div>
		<?php
	}

	// Featured image
	if ( !crown_art_sc_layouts_showed('featured'))
		crown_art_show_post_featured();
    ?><div class="post-body-single"><?php
	// Title and post meta
	if ( (!crown_art_sc_layouts_showed('title') || !crown_art_sc_layouts_showed('postmeta')) && !in_array(get_post_format(), array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php

            crown_art_show_post_meta(apply_filters('crown_art_filter_post_meta_args', array(
                    'components' => 'date',
                    'counters' => '',
                    'seo' => false
                ), 'excerpt', 1)
            );


			// Post title
			if (!crown_art_sc_layouts_showed('title')) {
				the_title( '<h3 class="post_title entry-title"'.(crown_art_is_on(crown_art_get_theme_option('seo_snippets')) ? ' itemprop="headline"' : '').'>', '</h3>' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	?>
	<div class="post_content entry-content" itemprop="articleBody">
		<?php
			the_content( );

			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'crown-art' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'crown-art' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

            // Post meta
            if (!crown_art_sc_layouts_showed('postmeta')) {
                crown_art_show_post_meta(apply_filters('crown_art_filter_post_meta_args', array(
                        'components' => 'categories,counters',
                        'counters' => 'comments',
                        'seo' => crown_art_is_on(crown_art_get_theme_option('seo_snippets'))
                    ), 'single', 1)
                );
            }

			// Taxonomies and share
			if ( is_single() && !is_attachment() ) {
				?>
				<div class="post_meta post_meta_single"><?php
					
					// Post taxonomies
					the_tags( '<span class="post_meta_item post_tags">', ', ', '</span>' );

					// Share
					crown_art_show_share_links(array(
							'type' => 'block',
							'caption' => '',
							'before' => '<span class="post_meta_item post_share">',
							'after' => '</span>'
						));
					?>
				</div>
				<?php
			}
		?>
	</div><!-- .entry-content -->
    </div>
	<?php
		// Author bio.
		if ( crown_art_get_theme_option('author_info')==1 && is_single() && !is_attachment() && get_the_author_meta( 'description' ) ) {
			get_template_part( 'templates/author-bio' );
		}
	?>
</article>
