<?php
/**
 * The Header: Logo and main menu
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js scheme_<?php
										 // Class scheme_xxx need in the <html> as context for the <body>!
										 echo esc_attr(crown_art_get_theme_option('color_scheme'));
										 ?>">
<head>
	<?php wp_head(); ?>
</head>

<body <?php	body_class(); ?>>
    <?php wp_body_open(); ?>

	<?php do_action( 'crown_art_action_before' ); ?>

	<div class="body_wrap">

		<div class="page_wrap">

			<?php
			// Desktop header
			$crown_art_header_style = crown_art_get_theme_option("header_style");
			if (strpos($crown_art_header_style, 'header-custom-')===0) $crown_art_header_style = 'header-custom';
			get_template_part( "templates/{$crown_art_header_style}");

			// Side menu
			if (in_array(crown_art_get_theme_option('menu_style'), array('left', 'right'))) {
				get_template_part( 'templates/header-navi-side' );
			}

			// Mobile header
			get_template_part( 'templates/header-mobile');
			?>

			<div class="page_content_wrap scheme_<?php echo esc_attr(crown_art_get_theme_option('color_scheme')); ?>">

				<?php if (crown_art_get_theme_option('body_style') != 'fullscreen') { ?>
				<div class="content_wrap">
				<?php } ?>

					<?php
					// Widgets area above page content
					crown_art_create_widgets_area('widgets_above_page');
					?>				

					<div class="content">
						<?php
						// Widgets area inside page content
						crown_art_create_widgets_area('widgets_above_content');
						?>				
