<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('crown_art_storage_get')) {
	function crown_art_storage_get($var_name, $default='') {
		global $CROWN_ART_STORAGE;
		return isset($CROWN_ART_STORAGE[$var_name]) ? $CROWN_ART_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('crown_art_storage_set')) {
	function crown_art_storage_set($var_name, $value) {
		global $CROWN_ART_STORAGE;
		$CROWN_ART_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('crown_art_storage_empty')) {
	function crown_art_storage_empty($var_name, $key='', $key2='') {
		global $CROWN_ART_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($CROWN_ART_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($CROWN_ART_STORAGE[$var_name][$key]);
		else
			return empty($CROWN_ART_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('crown_art_storage_isset')) {
	function crown_art_storage_isset($var_name, $key='', $key2='') {
		global $CROWN_ART_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($CROWN_ART_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($CROWN_ART_STORAGE[$var_name][$key]);
		else
			return isset($CROWN_ART_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('crown_art_storage_inc')) {
	function crown_art_storage_inc($var_name, $value=1) {
		global $CROWN_ART_STORAGE;
		if (empty($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = 0;
		$CROWN_ART_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('crown_art_storage_concat')) {
	function crown_art_storage_concat($var_name, $value) {
		global $CROWN_ART_STORAGE;
		if (empty($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = '';
		$CROWN_ART_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('crown_art_storage_get_array')) {
	function crown_art_storage_get_array($var_name, $key, $key2='', $default='') {
		global $CROWN_ART_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($CROWN_ART_STORAGE[$var_name][$key]) ? $CROWN_ART_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($CROWN_ART_STORAGE[$var_name][$key][$key2]) ? $CROWN_ART_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('crown_art_storage_set_array')) {
	function crown_art_storage_set_array($var_name, $key, $value) {
		global $CROWN_ART_STORAGE;
		if (!isset($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = array();
		if ($key==='')
			$CROWN_ART_STORAGE[$var_name][] = $value;
		else
			$CROWN_ART_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('crown_art_storage_set_array2')) {
	function crown_art_storage_set_array2($var_name, $key, $key2, $value) {
		global $CROWN_ART_STORAGE;
		if (!isset($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = array();
		if (!isset($CROWN_ART_STORAGE[$var_name][$key])) $CROWN_ART_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$CROWN_ART_STORAGE[$var_name][$key][] = $value;
		else
			$CROWN_ART_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('crown_art_storage_merge_array')) {
	function crown_art_storage_merge_array($var_name, $key, $value) {
		global $CROWN_ART_STORAGE;
		if (!isset($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = array();
		if ($key==='')
			$CROWN_ART_STORAGE[$var_name] = array_merge($CROWN_ART_STORAGE[$var_name], $value);
		else
			$CROWN_ART_STORAGE[$var_name][$key] = array_merge($CROWN_ART_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('crown_art_storage_set_array_after')) {
	function crown_art_storage_set_array_after($var_name, $after, $key, $value='') {
		global $CROWN_ART_STORAGE;
		if (!isset($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = array();
		if (is_array($key))
			crown_art_array_insert_after($CROWN_ART_STORAGE[$var_name], $after, $key);
		else
			crown_art_array_insert_after($CROWN_ART_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('crown_art_storage_set_array_before')) {
	function crown_art_storage_set_array_before($var_name, $before, $key, $value='') {
		global $CROWN_ART_STORAGE;
		if (!isset($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = array();
		if (is_array($key))
			crown_art_array_insert_before($CROWN_ART_STORAGE[$var_name], $before, $key);
		else
			crown_art_array_insert_before($CROWN_ART_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('crown_art_storage_push_array')) {
	function crown_art_storage_push_array($var_name, $key, $value) {
		global $CROWN_ART_STORAGE;
		if (!isset($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($CROWN_ART_STORAGE[$var_name], $value);
		else {
			if (!isset($CROWN_ART_STORAGE[$var_name][$key])) $CROWN_ART_STORAGE[$var_name][$key] = array();
			array_push($CROWN_ART_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('crown_art_storage_pop_array')) {
	function crown_art_storage_pop_array($var_name, $key='', $defa='') {
		global $CROWN_ART_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($CROWN_ART_STORAGE[$var_name]) && is_array($CROWN_ART_STORAGE[$var_name]) && count($CROWN_ART_STORAGE[$var_name]) > 0) 
				$rez = array_pop($CROWN_ART_STORAGE[$var_name]);
		} else {
			if (isset($CROWN_ART_STORAGE[$var_name][$key]) && is_array($CROWN_ART_STORAGE[$var_name][$key]) && count($CROWN_ART_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($CROWN_ART_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('crown_art_storage_inc_array')) {
	function crown_art_storage_inc_array($var_name, $key, $value=1) {
		global $CROWN_ART_STORAGE;
		if (!isset($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = array();
		if (empty($CROWN_ART_STORAGE[$var_name][$key])) $CROWN_ART_STORAGE[$var_name][$key] = 0;
		$CROWN_ART_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('crown_art_storage_concat_array')) {
	function crown_art_storage_concat_array($var_name, $key, $value) {
		global $CROWN_ART_STORAGE;
		if (!isset($CROWN_ART_STORAGE[$var_name])) $CROWN_ART_STORAGE[$var_name] = array();
		if (empty($CROWN_ART_STORAGE[$var_name][$key])) $CROWN_ART_STORAGE[$var_name][$key] = '';
		$CROWN_ART_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('crown_art_storage_call_obj_method')) {
	function crown_art_storage_call_obj_method($var_name, $method, $param=null) {
		global $CROWN_ART_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($CROWN_ART_STORAGE[$var_name]) ? $CROWN_ART_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($CROWN_ART_STORAGE[$var_name]) ? $CROWN_ART_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('crown_art_storage_get_obj_property')) {
	function crown_art_storage_get_obj_property($var_name, $prop, $default='') {
		global $CROWN_ART_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($CROWN_ART_STORAGE[$var_name]->$prop) ? $CROWN_ART_STORAGE[$var_name]->$prop : $default;
	}
}
?>