<?php
/**
 * The template for homepage posts with "Chess" style
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

crown_art_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$crown_art_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$crown_art_sticky_out = crown_art_get_theme_option('sticky_style')=='columns' 
							&& is_array($crown_art_stickies) && count($crown_art_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($crown_art_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$crown_art_sticky_out) {
		?><div class="chess_wrap posts_container"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($crown_art_sticky_out && !is_sticky()) {
			$crown_art_sticky_out = false;
			?></div><div class="chess_wrap posts_container"><?php
		}
		get_template_part( 'content', $crown_art_sticky_out && is_sticky() ? 'sticky' :'chess' );
	}
	
	?></div><?php

	crown_art_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>