<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

crown_art_storage_set('blog_archive', true);

// Load scripts for 'Masonry' layout
if (substr(crown_art_get_theme_option('blog_style'), 0, 7) == 'masonry') {
	wp_enqueue_script( 'imagesloaded' );
	wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'classie', crown_art_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
	wp_enqueue_script( 'crown-art-gallery-script', crown_art_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );
}

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$crown_art_classes = 'posts_container '
						. (substr(crown_art_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap' : 'masonry_wrap');
	$crown_art_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$crown_art_sticky_out = crown_art_get_theme_option('sticky_style')=='columns' 
							&& is_array($crown_art_stickies) && count($crown_art_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($crown_art_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$crown_art_sticky_out) {
		if (crown_art_get_theme_option('first_post_large') && !is_paged() && !in_array(crown_art_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($crown_art_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($crown_art_sticky_out && !is_sticky()) {
			$crown_art_sticky_out = false;
			?></div><div class="<?php echo esc_attr($crown_art_classes); ?>"><?php
		}
		get_template_part( 'content', $crown_art_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	crown_art_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>