<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

crown_art_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'imagesloaded' );
wp_enqueue_script( 'masonry' );
wp_enqueue_script( 'classie', crown_art_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'crown-art-gallery-script', crown_art_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$crown_art_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$crown_art_sticky_out = crown_art_get_theme_option('sticky_style')=='columns' 
							&& is_array($crown_art_stickies) && count($crown_art_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$crown_art_cat = crown_art_get_theme_option('parent_cat');
	$crown_art_post_type = crown_art_get_theme_option('post_type');
	$crown_art_taxonomy = crown_art_get_post_type_taxonomy($crown_art_post_type);
	$crown_art_show_filters = crown_art_get_theme_option('show_filters');
	$crown_art_tabs = array();
	if (!crown_art_is_off($crown_art_show_filters)) {
		$crown_art_args = array(
			'type'			=> $crown_art_post_type,
			'child_of'		=> $crown_art_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $crown_art_taxonomy,
			'pad_counts'	=> false
		);
		$crown_art_portfolio_list = get_terms($crown_art_args);
		if (is_array($crown_art_portfolio_list) && count($crown_art_portfolio_list) > 0) {
			$crown_art_tabs[$crown_art_cat] = esc_html__('All', 'crown-art');
			foreach ($crown_art_portfolio_list as $crown_art_term) {
				if (isset($crown_art_term->term_id)) $crown_art_tabs[$crown_art_term->term_id] = $crown_art_term->name;
			}
		}
	}
	if (count($crown_art_tabs) > 0) {
		$crown_art_portfolio_filters_ajax = true;
		$crown_art_portfolio_filters_active = $crown_art_cat;
		$crown_art_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters crown_art_tabs crown_art_tabs_ajax">
			<ul class="portfolio_titles crown_art_tabs_titles">
				<?php
				foreach ($crown_art_tabs as $crown_art_id=>$crown_art_title) {
					?><li><a href="<?php echo esc_url(crown_art_get_hash_link(sprintf('#%s_%s_content', $crown_art_portfolio_filters_id, $crown_art_id))); ?>" data-tab="<?php echo esc_attr($crown_art_id); ?>"><?php echo esc_html($crown_art_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$crown_art_ppp = crown_art_get_theme_option('posts_per_page');
			if (crown_art_is_inherit($crown_art_ppp)) $crown_art_ppp = '';
			foreach ($crown_art_tabs as $crown_art_id=>$crown_art_title) {
				$crown_art_portfolio_need_content = $crown_art_id==$crown_art_portfolio_filters_active || !$crown_art_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $crown_art_portfolio_filters_id, $crown_art_id)); ?>"
					class="portfolio_content crown_art_tabs_content"
					data-blog-template="<?php echo esc_attr(crown_art_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(crown_art_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($crown_art_ppp); ?>"
					data-post-type="<?php echo esc_attr($crown_art_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($crown_art_taxonomy); ?>"
					data-cat="<?php echo esc_attr($crown_art_id); ?>"
					data-parent-cat="<?php echo esc_attr($crown_art_cat); ?>"
					data-need-content="<?php echo (false===$crown_art_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($crown_art_portfolio_need_content) 
						crown_art_show_portfolio_posts(array(
							'cat' => $crown_art_id,
							'parent_cat' => $crown_art_cat,
							'taxonomy' => $crown_art_taxonomy,
							'post_type' => $crown_art_post_type,
							'page' => 1,
							'sticky' => $crown_art_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		crown_art_show_portfolio_posts(array(
			'cat' => $crown_art_cat,
			'parent_cat' => $crown_art_cat,
			'taxonomy' => $crown_art_taxonomy,
			'post_type' => $crown_art_post_type,
			'page' => 1,
			'sticky' => $crown_art_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>