<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('crown_art_cf7_theme_setup9')) {
	add_action( 'after_setup_theme', 'crown_art_cf7_theme_setup9', 9 );
	function crown_art_cf7_theme_setup9() {
		if (crown_art_exists_cf7()) {
			add_action( 'wp_enqueue_scripts', 								'crown_art_cf7_frontend_scripts', 1100 );
			add_filter( 'crown_art_filter_merge_styles',						'crown_art_cf7_merge_styles' );
			add_filter('wpcf7_autop_or_not', 'crown_art_cf7_wpcf7_autop');
		}
		if (is_admin()) {
			add_filter( 'crown_art_filter_tgmpa_required_plugins',			'crown_art_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'crown_art_cf7_tgmpa_required_plugins' ) ) {
	
	function crown_art_cf7_tgmpa_required_plugins($list=array()) {
		if (in_array('contact-form-7', crown_art_storage_get('required_plugins'))) {
			// CF7 plugin
			$list[] = array(
					'name' 		=> esc_html__('Contact Form 7', 'crown-art'),
					'slug' 		=> 'contact-form-7',
					'required' 	=> false
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( !function_exists( 'crown_art_exists_cf7' ) ) {
	function crown_art_exists_cf7() {
		return class_exists('WPCF7');
	}
}

// Remove <p> and <br/> from Contact Form 7
if ( ! function_exists( 'crown_art_cf7_wpcf7_autop' ) ) {
	function crown_art_cf7_wpcf7_autop() {
		return false;
	}
}

// Enqueue custom styles
if ( !function_exists( 'crown_art_cf7_frontend_scripts' ) ) {
	
	function crown_art_cf7_frontend_scripts() {
		if (crown_art_is_on(crown_art_get_theme_option('debug_mode')) && crown_art_get_file_dir('plugins/contact-form-7/contact-form-7.css')!='')
			wp_enqueue_style( 'crown-art-contact-form-7',  crown_art_get_file_url('plugins/contact-form-7/contact-form-7.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'crown_art_cf7_merge_styles' ) ) {
	
	function crown_art_cf7_merge_styles($list) {
		$list[] = 'plugins/contact-form-7/contact-form-7.css';
		return $list;
	}
}
?>