<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('crown_art_essential_grid_theme_setup9')) {
	add_action( 'after_setup_theme', 'crown_art_essential_grid_theme_setup9', 9 );
	function crown_art_essential_grid_theme_setup9() {
		if (crown_art_exists_essential_grid()) {
			add_action( 'wp_enqueue_scripts', 							'crown_art_essential_grid_frontend_scripts', 1100 );
			add_filter( 'crown_art_filter_merge_styles',					'crown_art_essential_grid_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'crown_art_filter_tgmpa_required_plugins',		'crown_art_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'crown_art_exists_essential_grid' ) ) {
	function crown_art_exists_essential_grid() {
		return defined('EG_PLUGIN_PATH') || defined( 'ESG_PLUGIN_PATH' );
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'crown_art_essential_grid_tgmpa_required_plugins' ) ) {
	
	function crown_art_essential_grid_tgmpa_required_plugins($list=array()) {
		if (in_array('essential-grid', crown_art_storage_get('required_plugins'))) {
			$path = crown_art_get_file_dir('plugins/essential-grid/essential-grid.zip');
			$list[] = array(
						'name' 		=> esc_html__('Essential Grid', 'crown-art'),
						'slug' 		=> 'essential-grid',
						'version'	=> '3.1.9.2',
						'source'	=> !empty($path) ? $path : 'upload://essential-grid.zip',
						'required' 	=> false
			);
		}
		return $list;
	}
}
	
// Enqueue plugin's custom styles
if ( !function_exists( 'crown_art_essential_grid_frontend_scripts' ) ) {
	
	function crown_art_essential_grid_frontend_scripts() {
		if (crown_art_is_on(crown_art_get_theme_option('debug_mode')) && crown_art_get_file_dir('plugins/essential-grid/essential-grid.css')!='')
			wp_enqueue_style( 'crown-art-essential-grid',  crown_art_get_file_url('plugins/essential-grid/essential-grid.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'crown_art_essential_grid_merge_styles' ) ) {
	
	function crown_art_essential_grid_merge_styles($list) {
		$list[] = 'plugins/essential-grid/essential-grid.css';
		return $list;
	}
}
?>