<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('crown_art_mailchimp_get_css')) {
	add_filter('crown_art_filter_get_css', 'crown_art_mailchimp_get_css', 10, 4);
	function crown_art_mailchimp_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		
			
			$rad = crown_art_get_border_radius();
			$css['fonts'] .= <<<CSS

.mc4wp-form .mc4wp-form-fields input[type="email"],
.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	-webkit-border-radius: {$rad};
	    -ms-border-radius: {$rad};
			border-radius: {$rad};
}

CSS;
		}

		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

.mc4wp-form input[type="email"] {
	background-color: {$colors['bd_color']};
	border-color: {$colors['bd_color']};
	color: {$colors['text_dark_05']};
}
.mc4wp-form input[type="email"]:hover {
	background-color: {$colors['bg_color']};
	border-color: {$colors['text_hover']};
	color: {$colors['text_dark']};
}
.mc4wp-form input[type="email"]:focus {
	background-color: {$colors['bg_color']};
	border-color: {$colors['text_hover']};
	color: {$colors['text_dark']};
}
.mc4wp-form input[type="submit"][disabled] {
    color: {$colors['text_light']} !important;
}
.mc4wp-form .mc4wp-alert {
	background-color: {$colors['bd_color']};
	border-color: {$colors['bd_color']};
	color: {$colors['text_dark']};
}
CSS;
		}

		return $css;
	}
}
?>