<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('crown_art_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'crown_art_revslider_theme_setup9', 9 );
	function crown_art_revslider_theme_setup9() {
		if (crown_art_exists_revslider()) {
			add_action( 'wp_enqueue_scripts', 					'crown_art_revslider_frontend_scripts', 1100 );
			add_filter( 'crown_art_filter_merge_styles',			'crown_art_revslider_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'crown_art_filter_tgmpa_required_plugins','crown_art_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'crown_art_exists_revslider' ) ) {
	function crown_art_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'crown_art_revslider_tgmpa_required_plugins' ) ) {
	
	function crown_art_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', crown_art_storage_get('required_plugins'))) {
			$path = crown_art_get_file_dir('plugins/revslider/revslider.zip');
			$list[] = array(
					'name' 		=> esc_html__('Revolution Slider', 'crown-art'),
					'slug' 		=> 'revslider',
					'version'	=> '6.7.35',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'crown_art_revslider_frontend_scripts' ) ) {
	
	function crown_art_revslider_frontend_scripts() {
		if (crown_art_is_on(crown_art_get_theme_option('debug_mode')) && crown_art_get_file_dir('plugins/revslider/revslider.css')!='')
			wp_enqueue_style( 'crown-art-revslider',  crown_art_get_file_url('plugins/revslider/revslider.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'crown_art_revslider_merge_styles' ) ) {
	
	function crown_art_revslider_merge_styles($list) {
		$list[] = 'plugins/revslider/revslider.css';
		return $list;
	}
}
?>