<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( !function_exists( 'crown_art_tribe_events_get_css' ) ) {
	add_filter( 'crown_art_filter_get_css', 'crown_art_tribe_events_get_css', 10, 4 );
	function crown_art_tribe_events_get_css($css, $colors, $fonts, $scheme='') {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS
			
.tribe-events-list .tribe-events-list-event-title {
	{$fonts['h3_font-family']}
}

#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
#tribe-bar-form button, #tribe-bar-form a,
.tribe-events-read-more {
	{$fonts['button_font-family']}
	{$fonts['button_letter-spacing']}
}
.tribe-events-list .tribe-events-list-separator-month,
.tribe-events-calendar thead th,
.tribe-events-schedule, .tribe-events-schedule h2 {
	{$fonts['h5_font-family']}
}

.tribe-events-event-meta,
.tribe-events .datepicker .day,
.tribe-events .datepicker .month,
.tribe-events .datepicker .year,
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
#tribe-bar-form input, #tribe-events-content.tribe-events-month,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-mobile-container .type-tribe_events,
.tribe-events-list-widget ol li .tribe-event-title {
	{$fonts['p_font-family']}
}
.tribe-events-loop .tribe-event-schedule-details,
.single-tribe_events #tribe-events-content .tribe-events-event-meta dt,
#tribe-mobile-container .type-tribe_events .tribe-event-date-start {
	{$fonts['info_font-family']};
}

.tribe-events .datepicker .dow,
.tribe-common .tribe-common-h7, 
.tribe-common .tribe-common-h8,
.tribe-common .tribe-events-calendar-month__calendar-event-tooltip-title.tribe-common-h7,
.tribe-common .tribe-events-calendar-day__event-title.tribe-common-h6,
.tribe-common .tribe-events-calendar-list__event .tribe-common-h6,
.tribe-common .tribe-events-calendar-month__header-row .tribe-common-b3,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__header-column-title,
#tribe-bar-form label {
	{$fonts['h5_font-family']}
}

.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item,
.tribe-events-content,
.tribe-events .datepicker .datepicker-switch,
.tribe-events .datepicker .month, 
.tribe-events .datepicker .year,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-common .tribe-common-b2,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-form-control-text__input, 
.tribe-common .tribe-common-form-control-text__input,
.tribe-common .tribe-common-b3,
.tribe-common .tribe-common-h5,
.tribe-common .tribe-events-calendar-list__event .tribe-common-b2,
#tribe-bar-form input, #tribe-events-content.tribe-events-month,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-mobile-container .type-tribe_events,
.tribe-events-list-widget ol li .tribe-event-title {
	{$fonts['p_font-family']}
}
.tribe-events-loop .tribe-event-schedule-details,
#tribe-mobile-container .type-tribe_events .tribe-event-date-start {
	{$fonts['info_font-family']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__day-date-daynum{
    {$fonts['p_font-family']}
}

.tribe-common .tribe-common-c-btn-border-small,
.tribe-common a.tribe-common-c-btn-border-small,
.tribe-common .tribe-common-c-btn,
.tribe-events .tribe-events-c-view-selector__list-item-text,
.tribe-common .tribe-common-c-btn-border, 
.tribe-common a.tribe-common-c-btn-border,
.tribe-common-c-btn-border.tribe-events-c-subscribe-dropdown__button,
.tribe-common .tribe-common-h3,
.tribe-common .tribe-common-h4,
.tribe-common .tribe-common-h8,
.tribe-common.tribe-events .tribe-events-c-search__button,
.tribe-common.tribe-events button.tribe-events-c-search__button,
#tribe-bar-form button, #tribe-bar-form a,
.tribe-events-read-more {
	{$fonts['button_font-family']}
	{$fonts['button_letter-spacing']}
}

CSS;

			
			$rad = crown_art_get_border_radius();
			$css['fonts'] .= <<<CSS

#tribe-bar-form .tribe-bar-submit input[type="submit"], #tribe-bar-form button, #tribe-bar-form a,
#tribe-events .tribe-events-button,
#tribe-bar-views .tribe-bar-views-list,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a {
	-webkit-border-radius: {$rad};
	    -ms-border-radius: {$rad};
			border-radius: {$rad};
}

CSS;
		}


		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Filters bar */
#tribe-bar-form {
	color: {$colors['text_dark']};
}
#tribe-bar-form input[type="text"] {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
.datepicker thead tr:first-child th:hover, .datepicker tfoot tr th:hover {
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}

button#tribe-bar-views-toggle {
	color: {$colors['bg_color']};
}
#tribe-bar-views .tribe-bar-views-list {
	background: linear-gradient(to bottom right, {$colors['text_link3']}, {$colors['text_hover3']});
}
#tribe-bar-views .tribe-bar-views-option {
	color: {$colors['bg_color']};
}
#tribe-bar-views .tribe-bar-views-option:hover,
#tribe-bar-views .tribe-bar-views-option.tribe-bar-active{
	background: {$colors['text_hover']};
}

/* Content */
.tribe-events-calendar thead th {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']} !important;
	border-color: {$colors['text_dark']} !important;
}
.tribe-events-calendar thead th + th:before {
	background: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-calendar td {
	border-color: {$colors['bd_color']} !important;
}
.tribe-events-calendar td div[id*="tribe-events-daynum-"],
.tribe-events-calendar td div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_dark']};
}
.tribe-events-calendar td.tribe-events-othermonth {
	color: {$colors['alter_light']};
	background: {$colors['alter_bg_color']} !important;
}
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"] > a {
	color: {$colors['alter_light']};
}
.tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"], .tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_light']};
}
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_link']};
}
.tribe-events-calendar td.tribe-events-present:before {
	border-color: {$colors['text_link']};
}
.tribe-events-calendar .tribe-events-has-events:after {
	background-color: {$colors['text_link']};
}
.tribe-events-calendar .mobile-active.tribe-events-has-events:after {
	background-color: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active{
	background-color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active:hover {
	background-color: {$colors['text_hover']};
}

#tribe-events-content .tribe-events-calendar td.mobile-active a:hover {
	color: {$colors['bg_color']};
}

#tribe-events-content .tribe-events-calendar td.mobile-active div[id*="tribe-events-daynum-"] {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar td.tribe-events-othermonth.mobile-active div[id*="tribe-events-daynum-"] a,
.tribe-events-calendar .mobile-active div[id*="tribe-events-daynum-"] a {
	background-color: transparent;
	color: {$colors['bg_color']};
}

/* Tooltip */
.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip,
.tribe-events-tooltip .tribe-events-arrow {
	color: {$colors['alter_text']};
	background: {$colors['alter_bg_color']};
}
#tribe-events-content .tribe-events-tooltip h4 { 
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}
.tribe-events-tooltip .tribe-event-duration {
	color: {$colors['text_light']};
}

.tribe-common-c-btn-border.tribe-events-c-subscribe-dropdown__button {
    color: {$colors['alter_link']};
    border-color: {$colors['alter_link']};
    background-color: {$colors['inverse_link']};
}
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button.tribe-events-c-subscribe-dropdown__button--active,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:focus,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:focus-within,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:hover {
    color: {$colors['inverse_link']};
    border-color: {$colors['alter_link']};
    background-color: {$colors['alter_link']};
}

/* Events list */
.tribe-events-list-separator-month {
	color: {$colors['text_dark']};
}
.tribe-events-list-separator-month:after {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .type-tribe_events + .type-tribe_events {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .tribe-events-event-cost span {
	color: {$colors['bg_color']};
	border-color: {$colors['text_dark']};
	background: {$colors['text_dark']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a {
	color: {$colors['alter_link']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a:hover {
	color: {$colors['alter_hover']};
}
.tribe-mobile .tribe-events-list .tribe-events-venue-details {
	border-color: {$colors['alter_bd_color']};
}

/* Events day */
.tribe-events-day .tribe-events-day-time-slot h5 {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']};
}

/* Single Event */
.single-tribe_events .tribe-events-venue-map {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_hover']};
	background: {$colors['alter_bg_hover']};
}
.single-tribe_events .tribe-events-schedule .tribe-events-cost {
	color: {$colors['text_dark']};
}
.single-tribe_events .type-tribe_events {
	border-color: {$colors['bd_color']};
}


/*--------new----*/

.tribe-common .tribe-common-anchor-thin-alt:hover,
.tribe-common .tribe-common-anchor-thin-alt:focus,
.tribe-common .tribe-common-anchor-thin-alt:active,
.tribe-events-c-top-bar__datepicker > button,
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date, 
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link,
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_link']};
}

.tribe-common a {
	color: {$colors['text_dark']};
}
.tribe-common a:active,
.tribe-common a:focus,
.tribe-common a:hover,
.tribe-common a:visited {
	color: {$colors['text_link']};
}

.tribe-events-c-top-bar__datepicker > button .tribe-common-c-svgicon__svg-fill {
    fill: {$colors['text_link']};
}
.tribe-events-c-top-bar__datepicker > button:hover .tribe-common-c-svgicon__svg-fill {
    fill: {$colors['text_dark']};
}

.tribe-common .tribe-common-c-svgicon__svg-fill,
.tribe-events .tribe-events-c-events-bar__search-button .tribe-events-c-events-bar__search-button-icon-svg path {
    fill: {$colors['text_dark']};
}

.tribe-common .tribe-common-anchor-thin-alt,
.tribe-common .tribe-common-anchor-thin-alt:focus{
    border-color: {$colors['text_link']};
}
.tribe-events .datepicker .day.active,
.tribe-events .tribe-events-c-events-bar__search-button:before,
.tribe-events .tribe-events-c-view-selector__button:before,
.tribe-events .datepicker .year.active,
.tribe-events .datepicker .month.active:hover,
.tribe-events .datepicker .month.active, .tribe-events .datepicker .month.active.focused {
 	color: {$colors['inverse_link']} !important;
    background-color: {$colors['text_link']};
}

.tribe-events-calendar-day-nav button:hover,
.tribe-events-calendar-list-nav button:hover,
.tribe-events-c-top-bar__datepicker > button:focus,
.tribe-events-c-top-bar__datepicker > button:hover{
    color: {$colors['text_dark']}!important;
}


.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner {	
	 background-color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-month__mobile-events-icon--event,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-view-selector--tabs .tribe-events-c-view-selector__list-item--active .tribe-events-c-view-selector__list-item-link:after{
    background-color: {$colors['text_link']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-events-bar--border{
    border-color: {$colors['input_bg_color']};
}

.tribe-common .tribe-events-calendar-month__day--past .tribe-common-h4{
	color: {$colors['text_light']};
}

.tribe-common .tribe-events-calendar-month__day--current .tribe-common-h4{
	color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner .tribe-common-h8{
    color: {$colors['extra_dark']};
}

.tribe-events-calendar-month__calendar-event-tooltip-title > a,
.tribe-common .tribe-events-calendar-day__event-title.tribe-common-h6 > a,
.tribe-common .tribe-events-calendar-list__event .tribe-common-h6 > a{
	color: {$colors['text_dark']};
}
.tribe-events-calendar-month__calendar-event-tooltip-title > a:hover,
.tribe-common .tribe-events-calendar-day__event-title.tribe-common-h6 > a:hover,
.tribe-common .tribe-events-calendar-list__event .tribe-common-h6 > a:hover{
	color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.single-tribe_events .tribe-events-single .tribe-events-event-meta,
.tribe-events-content,
.tribe-common .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-common .tribe-events-calendar-day__event-datetime,
.tribe-common .tribe-events-calendar-day__event-header address,
.tribe-common .tribe-events-calendar-day__event-description,
.tribe-common .tribe-events-calendar-list__event-datetime,
.tribe-common .tribe-events-calendar-list__event-header address,
.tribe-common .tribe-events-calendar-list__event-description,
.tribe-events-calendar-month__calendar-event-tooltip-description{
    color: {$colors['text']};
}

.tribe-events .tribe-events-calendar-month__day-date-daynum,
.tribe-events .tribe-events-calendar-month__day--past .tribe-events-calendar-month__day-date-link,
.tribe-events .datepicker .datepicker-switch,
.tribe-events .datepicker .dow,
.tribe-events .datepicker .day,
.tribe-events .datepicker .month,
.tribe-events .datepicker .year,
.tribe-events .tribe-events-c-view-selector__list-item-text,
.tribe-common .tribe-common-h5, .tribe-common .tribe-common-h6,
.tribe-common .tribe-common-h7, .tribe-common .tribe-common-h8,
.tribe-events-meta-group .tribe-events-single-section-title {
	color: {$colors['text_dark']};
}

.tribe-events .datepicker .day.focused,
.tribe-events .datepicker .day:focus,
.tribe-events .datepicker .day:hover,
.tribe-events .datepicker .month.focused,
.tribe-events .datepicker .month:focus,
.tribe-events .datepicker .month:hover,
.tribe-events .datepicker .year.focused,
.tribe-events .datepicker .year:focus,
.tribe-events .datepicker .year:hover {
 	color: {$colors['inverse_link']} !important;
    background-color: {$colors['text_link']};
}

.tribe-events .datepicker .past.day,
.tribe-events .datepicker .past.month,
.tribe-events .datepicker .past.year {
	color: {$colors['text_light']};
}

.tribe-events .datepicker .datepicker-switch:focus,
.tribe-events .datepicker .datepicker-switch:hover {
	color: {$colors['text_link']};
}

.tribe-common .tribe-common-c-btn-border-small,
.tribe-common a.tribe-common-c-btn-border-small {
    color: {$colors['text']};
    border-color: {$colors['bd_color']};
}

.tribe-common .tribe-common-c-btn-border-small:hover,
.tribe-common a.tribe-common-c-btn-border-small:hover {
    color: {$colors['inverse_link']};
    border-color: {$colors['text_link']};
    background-color: {$colors['text_link']};
}

.tribe-events .datepicker .next .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .prev .tribe-events-c-top-bar__datepicker-nav-icon-svg path {
       fill: {$colors['text_dark']};
}

.tribe-events .tribe-events-c-nav__next:focus .tribe-events-c-nav__next-icon-svg path,
.tribe-events .tribe-events-c-nav__next:hover .tribe-events-c-nav__next-icon-svg path,
.tribe-events button.tribe-events-c-nav__next:focus .tribe-events-c-nav__next-icon-svg path,
.tribe-events button.tribe-events-c-nav__next:hover .tribe-events-c-nav__next-icon-svg path,
.tribe-events .tribe-events-c-nav__prev:focus .tribe-events-c-nav__prev-icon-svg path,
.tribe-events .tribe-events-c-nav__prev:hover .tribe-events-c-nav__prev-icon-svg path,
.tribe-events button.tribe-events-c-nav__prev:focus .tribe-events-c-nav__prev-icon-svg path,
.tribe-events button.tribe-events-c-nav__prev:hover .tribe-events-c-nav__prev-icon-svg path,
.tribe-events .datepicker .next:active .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .next:focus .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .next:hover .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .prev:active .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .prev:focus .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .prev:hover .tribe-events-c-top-bar__datepicker-nav-icon-svg path {
	fill: {$colors['text_link']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next-icon-svg path,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev-icon-svg path {
    fill: {$colors['text_dark']};
}


.tribe-events .tribe-events-c-nav__prev:disabled .tribe-events-c-nav__prev-icon-svg path,
.tribe-events button.tribe-events-c-nav__prev:disabled .tribe-events-c-nav__prev-icon-svg path,
.tribe-events .tribe-events-c-nav__next:disabled .tribe-events-c-nav__next-icon-svg path,
.tribe-events button.tribe-events-c-nav__next:disabled .tribe-events-c-nav__next-icon-svg path,
.tribe-common .tribe-common-c-btn-icon--caret-left:disabled .tribe-common-c-btn-icon__icon-svg path,
.tribe-common .tribe-common-c-btn-icon--caret-right:disabled .tribe-common-c-btn-icon__icon-svg path {
    fill: {$colors['text_light']};
}

.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list {
	border-color: {$colors['bd_color']};
}

.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:active,
.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:focus,
.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:focus-within,
.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:hover,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:active,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:focus,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:focus-within,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:hover {
    background-color: {$colors['alter_bg_color']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__day:hover:after {
    background-color: {$colors['text_dark']};
}

.tribe-events .tribe-events-c-view-selector__list-item-link:focus .tribe-events-c-view-selector__list-item-text,
.tribe-events .tribe-events-c-view-selector__list-item-link:hover .tribe-events-c-view-selector__list-item-text,
.tribe-events .tribe-events-c-events-bar .tribe-common-form-control-text__input{
    color: {$colors['text_dark']};
}

.tribe-events .tribe-events-calendar-month__header-column-title{
    color: {$colors['text']};
}

.tribe-events-calendar-month__day-cell--selected.tribe-events-calendar-month__day-cell{
    background-color: {$colors['text_link']} !important;
}

.tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__mobile-events-icon--event{
    background-color: {$colors['inverse_link']};
}

.tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__day-date-daynum{
    color: {$colors['inverse_link']};
}

.tribe-common .tribe-common-c-loader__dot{
    color: {$colors['text_link']};
}

table[class*="tribe-events"] thead > tr { 
	border-bottom-color: {$colors['bd_color']};
}
CSS;
		}
		
		return $css;
	}
}
?>