<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('crown_art_trx_addons_get_mycss')) {
	add_filter('crown_art_filter_get_css', 'crown_art_trx_addons_get_mycss', 10, 4);
	function crown_art_trx_addons_get_mycss($css, $colors, $fonts, $scheme='') {

        if (isset($css['fonts']) && $fonts) {
            $css['fonts'] .= <<<CSS
            .mejs-container .mejs-controls .mejs-time * {
                {$fonts['p_font-family']}
            }
            .trx_addons_priced,
            .sc_courses_price_style .sc_courses_item_price,
            .trx_addons_dropcap {
                {$fonts['h1_font-family']}
            }

CSS;
        }

        if (isset($css['colors']) && $colors) {
            $css['colors'] .= <<<CSS
    .trx_addons_accent_hovered {
        color: {$colors['text_hover']};
    }
    .trx_addons_accent_bg {
        background-color: {$colors['alter_link']};
        color: {$colors['bg_color']};
    }
    .trx_addons_tooltip:before {
        background-color: {$colors['alter_dark']};
    }
    .trx_addons_tooltip:after {
        border-top-color: {$colors['alter_dark']};
    }
    .trx_addons_dropcap_style_1 {
        background: linear-gradient(to right, {$colors['text_link2']}, {$colors['text_hover2']});
        color: {$colors['bg_color']};
    }
    .trx_addons_dropcap_style_2 {
        background: linear-gradient(to right, {$colors['text_link3']}, {$colors['text_hover3']});
        color: {$colors['bg_color']};
    }
    ul[class*="trx_addons_list"]>li:before,
    ul[class*="trx_addons_list_custom"] > li:before {
        color: {$colors['alter_link']};
    }
    .sc_table table tr:first-child {
        background: linear-gradient(to right, {$colors['text_link2']}, {$colors['text_hover2']});
    }
    .sc_table table tr:first-child th {
        border-color: {$colors['bg_color']};
    }
    .sc_layouts_menu_popup .sc_layouts_menu_nav > li > a,
    .sc_layouts_menu_nav > li li > a {
        color: {$colors['inverse_link']} !important;
    }
    .sc_layouts_menu_nav>li li.current-menu-item>a,
    .sc_layouts_menu_nav>li li.current-menu-parent>a,
    .sc_layouts_menu_nav>li li.current-menu-ancestor>a,
    .sc_layouts_menu_popup .sc_layouts_menu_nav > li > a:hover,
    .sc_layouts_menu_popup .sc_layouts_menu_nav > li.sfHover > a,
    .sc_layouts_menu_nav > li li > a:hover,
    .sc_layouts_menu_nav > li li.sfHover > a,
    .sc_layouts_menu_nav > li.current-menu-item > a,
    .sc_layouts_menu_nav > li.current-menu-parent > a,
    .sc_layouts_menu_nav > li.current-menu-ancestor > a,
    .sc_layouts_menu_nav > li > a:hover,
    .sc_layouts_menu_nav > li.sfHover > a,
    .sc_layouts_menu_nav > li > a:hover {
        color: {$colors['alter_link']} !important;
        background-color: {$colors['bg_color_0']};
    }
    .sc_layouts_menu_popup .sc_layouts_menu_nav,
    .sc_layouts_menu_nav > li ul {
        background: linear-gradient(to bottom right, {$colors['text_link3']}, {$colors['text_hover3']});
    }

    .scheme_self.footer_wrap .sc_layouts_row {
	    color: {$colors['text_dark_05']};
	    background-color: {$colors['bg_color']};
    }
    .scheme_self.footer_wrap li a {
        color: {$colors['text_dark_05']};
    }
    .scheme_self.footer_wrap li a:hover {
        color: {$colors['text_dark']};
    }
    .scheme_self.footer_wrap a {
        color: {$colors['text_dark_05']};
    }
    .scheme_self.footer_wrap a:hover {
        color: {$colors['text_dark']};
    }

    /* Video */
    .trx_addons_video_player.with_cover .video_hover,
    .format-video .post_featured.with_thumb .post_video_hover {
        color: {$colors['bg_color']};
        background-color: {$colors['alter_link']};
    }
    .trx_addons_video_player.with_cover .video_hover:hover,
    .format-video .post_featured.with_thumb .post_video_hover:hover {
        color: {$colors['inverse_link']};
        background-color: {$colors['text_link']};
    }
    .sc_slider_controls .slider_controls_wrap > a,
    .slider_swiper.slider_controls_side .slider_controls_wrap > a,
    .slider_outer_controls_side .slider_controls_wrap > a {
        color: {$colors['bg_color']};
        background-color: {$colors['alter_link']};
        border-color: {$colors['alter_link']};
    }
    .sc_slider_controls .slider_controls_wrap > a:hover,
    .slider_swiper.slider_controls_side .slider_controls_wrap > a:hover,
    .slider_outer_controls_side .slider_controls_wrap > a:hover {
        color: {$colors['bg_color']};
        background-color: {$colors['text_link']};
        border-color: {$colors['text_link']};
    }
    .trx_addons_audio_player.without_cover {
        color: {$colors['bg_color']};
        background-color: {$colors['alter_dark']};
        border-color: {$colors['alter_dark']};
    }
    .trx_addons_audio_player.without_cover .audio_author,
    .trx_addons_audio_player .audio_author + .audio_caption,
    .trx_addons_audio_player .mejs-container .mejs-controls .mejs-time {
         color: {$colors['bg_color']};
    }
    .trx_addons_audio_player .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total:before,
    .trx_addons_audio_player .mejs-controls .mejs-time-rail .mejs-time-total:before {
        background-color: {$colors['bg_color']};
    }
    .mejs-controls .mejs-button,
    .mejs-controls .mejs-time-rail .mejs-time-current,
    .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current {
        background-color: {$colors['alter_link']};
    }

    .mejs-controls .mejs-time-rail .mejs-time-total,
    .mejs-controls .mejs-time-rail .mejs-time-loaded,
    .mejs-container .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total {
        background: {$colors['bg_color']};
    }
    .mejs-controls .mejs-button:hover {
       background-color: {$colors['bg_color']};
    }
    .sc_price_info .sc_price_subtitle,
    .sc_skills .sc_skills_total {
        color: {$colors['text_dark']};
    }
    .sc_countdown_title {
        color: {$colors['alter_link']};
    }
    .sc_countdown_default .sc_countdown_digits span {
        background-color: {$colors['bg_color_0']};
    }
    .sc_price {
        color: {$colors['text']};
        background-color: {$colors['alter_bg_color']};
        border-color: {$colors['alter_bg_color']};
    }
    .sc_price:hover {
        color: {$colors['text']};
        background-color: {$colors['alter_bg_color']};
        border-color: {$colors['alter_bg_color']};
    }
    .sc_price_info .sc_price_description,
    .sc_price_info .sc_price_details {
        color: {$colors['text']};
    }
    .sc_price_info .sc_price_price {
        color: {$colors['text_dark']};
    }
    .sc_price_info .sc_price_title {
       color: {$colors['bg_color']};
       background-color: {$colors['alter_link']};
    }
    .wpb_column:nth-child(3n+2) .sc_price_info .sc_price_title {
       background-color: {$colors['text_hover']};
    }
    .wpb_column:nth-child(3n+3) .sc_price_info .sc_price_title {
       background-color: {$colors['alter_link2']};
    }
    .sc_price_info .sc_price_title a {
         color: {$colors['bg_color']};
    }
    .sc_price:hover .sc_price_info .sc_price_title a,
    .sc_price_info .sc_price_title a:hover {
         color: {$colors['bg_color_08']};
    }
    .sc_price_price em {
        color: {$colors['text']};
    }
    .sc_price:hover .sc_price_link, .sc_price_link:hover {
        color: {$colors['bg_color']};
    }
    .sc_testimonials_item_author_title,
    .scheme_dark .sc_item_subtitle {
        color: {$colors['alter_link']};
    }
    .sc_item_subtitle {
        color: {$colors['text_hover']};
    }
    .sc_googlemap_content,
    .scheme_self.sc_googlemap_content {
        color: {$colors['text_dark']};
        background-color: {$colors['text_hover']};
    }
    .widget_contacts .contacts_info {
        color: {$colors['text_dark']};
    }
    .service_caption {
         color: {$colors['text_hover']};
    }
    .sc_events_date {
        color: {$colors['text_hover']};
    }
    .sc_events_default .sc_events_item {
        background-color: {$colors['bg_color_0']};
    }
    .sc_events_default .sc_events_item + .sc_events_item {
        border-color: {$colors['bd_color']};
    }
    .sc_promo .sc_countdown {
        color: {$colors['bg_color']};
        background-color: {$colors['alter_dark']};
    }
    .sc_promo .sc_countdown_default .sc_countdown_digits span {
        color: {$colors['bg_color']};
    }
    .sc_events_title a:hover {
          color: {$colors['text_hover']};
    }
    .sc_courses_item_categories a,
    .team-image .post_featured + .sc_team_item_subtitle {
        color: {$colors['bg_color']};
        background-color: {$colors['alter_dark']};
    }
    .sc_courses_item_categories a:hover {
        color: {$colors['bg_color']};
        background-color: {$colors['text_hover']};
    }
    .sc_team .trx_addons_hover_mask {
        background-color: {$colors['alter_link_06']};
    }
    .sc_team .sc_team_item_thumb .sc_team_item_socials .social_item .social_icon {
        color: {$colors['alter_dark']};
        background-color: {$colors['bg_color']};
    }
    .sc_team .sc_team_item_thumb .sc_team_item_socials .social_item:hover .social_icon {
        color: {$colors['bg_color']};
        background-color: {$colors['text_hover']};
    }
    .team_member_page .team_member_position {
        color: {$colors['text_hover']};
    }
    .team_member_page .team_member_socials .social_item .social_icon {
        background-color: {$colors['bg_color_0']};
        color: {$colors['alter_link']};
    }
     .team_member_page .team_member_socials .social_item:hover .social_icon {
        background-color: {$colors['bg_color_0']};
        color: {$colors['text_link']};
    }
    .sc_courses_default .sc_courses_item {
        background-color: {$colors['bg_color_0']};
    }
    .sc_courses_default .sc_courses_item_price,
    .sc_courses_default .sc_courses_item_date {
        color: {$colors['bg_color']};
    }
    .courses_single .courses_page_meta_item_date {
        color: {$colors['text_link']};
    }
    .courses_single .courses_page_meta {
        color: {$colors['text_hover']};
    }
    .sc_courses_price_style .trx_addons_hover_mask {
        background-color: {$colors['alter_link_06']};
    }
    .sc_courses_price_style .sc_courses_item_meta,
    .sc_courses_item_tutor {
        color: {$colors['text_dark']};
    }
    .sc_courses_price_style .course_caption {
        color: {$colors['text_hover']};
    }
    .trx_addons_priced,
    .sc_courses_price_style .sc_courses_item_price {
        color: {$colors['text_link']};
    }
    .trx_addons_priced em,
    .sc_courses_price_style .sc_courses_item_price .sc_courses_item_period {
        color: {$colors['text_dark']};
    }
    body .vc_row-has-fill .cq-highlight-container .cq-highlight-label {
        color: {$colors['bg_color']};
    }
    .sc_testimonials_simple .sc_testimonials_item_author_title {
        color: {$colors['bg_color']};
    }
    .sc_testimonials_simple .sc_testimonials_item_author_socials a {
         color: {$colors['text_hover']};
    }
    .sc_testimonials_simple .sc_testimonials_item_author_socials a:hover {
         color: {$colors['text_link']};
    }
    .BigWhiteText em {
        color: {$colors['alter_link']};
    }
    .custom .tp-bullet,
    .custom .sr7-bullet {
        background-color: {$colors['bg_color_04']}!important;
    }
    .custom .tp-bullet.selected,
    .custom .tp-bullet:hover,
    .custom .sr7-bullet.selected,
    .custom .sr7-bullet:hover {
        background: transparent!important;
    }
    .custom .tp-bullet.selected:after,
    .custom .tp-bullet:hover:after,
    .custom .sr7-bullet.selected:after,
    .custom .sr7-bullet:hover:after {
        border-color: {$colors['alter_link']}!important;
    }
    .sc_services_default .sc_services_item_icon {
        background-color: {$colors['bg_color_0']};
        color: {$colors['text_hover']};
    }
    .sc_services_default .sc_services_item:hover .sc_services_item_title a,
    .sc_services_default .sc_services_item:hover .sc_services_item_icon,
    .sc_services_default .sc_services_item_icon:hover {
        background-color: {$colors['bg_color_0']};
        color: {$colors['text_link']};
    }
    blockquote.trx_addons_blockquote_style_2 {
        background-color: {$colors['bg_color_0']};
        color: {$colors['text_dark']};
    }
    blockquote.trx_addons_blockquote_style_2:before,
    blockquote.trx_addons_blockquote_style_2 a,
    blockquote.trx_addons_blockquote_style_2 cite {
        color: {$colors['text_hover']};
    }
    .trx_addons_dark {
        color: {$colors['text_dark_08']};
    }
    .top_panel .sc_layouts_row_type_normal .socials_wrap .social_item .social_icon {
        background-color: {$colors['bg_color']};
         color: {$colors['text_dark']};
    }
    .top_panel .sc_layouts_row_type_normal .socials_wrap .social_item .social_icon:hover {
        background-color: {$colors['alter_link']};
        color: {$colors['bg_color']};
    }
    .post_item_none_search .search_wrap .search_submit, .post_item_none_archive .search_wrap .search_submit {
        color: {$colors['text_dark']};
    }
    .post_item_none_search .search_wrap .search_submit:hover, .post_item_none_archive .search_wrap .search_submit:hover {
        color: {$colors['text_hover']};
    }

CSS;
		}

		return $css;
	}
}
?>