<?php
/* WPBakery Page Builder Extensions Bundle support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('crown_art_vc_extensions_theme_setup9')) {
	add_action( 'after_setup_theme', 'crown_art_vc_extensions_theme_setup9', 9 );
	function crown_art_vc_extensions_theme_setup9() {
		if (crown_art_exists_visual_composer()) {
			add_action( 'wp_enqueue_scripts', 								'crown_art_vc_extensions_frontend_scripts', 1100 );
			add_filter( 'crown_art_filter_merge_styles',						'crown_art_vc_extensions_merge_styles' );
		}
	
		if (is_admin()) {
			add_filter( 'crown_art_filter_tgmpa_required_plugins',		'crown_art_vc_extensions_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'crown_art_vc_extensions_tgmpa_required_plugins' ) ) {
	
	function crown_art_vc_extensions_tgmpa_required_plugins($list=array()) {
		if (in_array('vc-extensions-bundle', crown_art_storage_get('required_plugins'))) {
			$path = crown_art_get_file_dir('plugins/vc-extensions-bundle/vc-extensions-bundle.zip');
			$list[] = array(
					'name' 		=> esc_html__('WPBakery Page Builder Extensions Bundle', 'crown-art'),
					'slug' 		=> 'vc-extensions-bundle',
					'version'	=> '3.6.7',
					'source'	=> !empty($path) ? $path : 'upload://vc-extensions-bundle.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if VC Extensions installed and activated
if ( !function_exists( 'crown_art_exists_vc_extensions' ) ) {
	function crown_art_exists_vc_extensions() {
		return class_exists('Vc_Manager') && class_exists('VC_Extensions_CQBundle');
	}
}
	
// Enqueue VC custom styles
if ( !function_exists( 'crown_art_vc_extensions_frontend_scripts' ) ) {
	
	function crown_art_vc_extensions_frontend_scripts() {
		if (crown_art_is_on(crown_art_get_theme_option('debug_mode')) && crown_art_get_file_dir('plugins/vc-extensions-bundle/vc-extensions-bundle.css')!='')
			wp_enqueue_style( 'crown-art-vc-extensions-bundle',  crown_art_get_file_url('plugins/vc-extensions-bundle/vc-extensions-bundle.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'crown_art_vc_extensions_merge_styles' ) ) {
	
	function crown_art_vc_extensions_merge_styles($list) {
		$list[] = 'plugins/vc-extensions-bundle/vc-extensions-bundle.css';
		return $list;
	}
}
?>