<?php
/* WP GDPR Compliance support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'crown_art_wp_gdpr_compliance_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'crown_art_wp_gdpr_compliance_theme_setup9', 9 );
	function crown_art_wp_gdpr_compliance_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'crown_art_filter_tgmpa_required_plugins', 'crown_art_wp_gdpr_compliance_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'crown_art_wp_gdpr_compliance_tgmpa_required_plugins' ) ) {
	function crown_art_wp_gdpr_compliance_tgmpa_required_plugins($list=array()) {
		if (in_array('wp-gdpr-compliance', crown_art_storage_get('required_plugins')))
			$list[] = array(
				'name' 		=> esc_html__('Cookie Information', 'crown-art'),
				'slug' 		=> 'wp-gdpr-compliance',
				'required' 	=> false
			);
		return $list;
	}
}

// Check if this plugin installed and activated
if ( ! function_exists( 'crown_art_exists_wp_gdpr_compliance' ) ) {
	function crown_art_exists_wp_gdpr_compliance() {
        	return defined( 'WP_GDPR_C_ROOT_FILE' ) || defined( 'WPGDPRC_ROOT_FILE' );
	}
}
