<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_sidebar_position = crown_art_get_theme_option('sidebar_position');
if (crown_art_sidebar_present()) {
	ob_start();
	$crown_art_sidebar_name = crown_art_get_theme_option('sidebar_widgets');
	crown_art_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($crown_art_sidebar_name) ) {
		dynamic_sidebar($crown_art_sidebar_name);
	}
	$crown_art_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($crown_art_out)) {
		?>
		<div class="sidebar <?php echo esc_attr($crown_art_sidebar_position); ?> widget_area<?php if (!crown_art_is_inherit(crown_art_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(crown_art_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'crown_art_action_before_sidebar' );
				crown_art_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $crown_art_out));
				do_action( 'crown_art_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>