<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0.1
 */
?>
<div class="update-nag" id="crown_art_admin_notice">
	<h3 class="crown_art_notice_title"><?php echo sprintf(esc_html__('Welcome to %s', 'crown-art'), wp_get_theme()->name); ?></h3>
	<?php
	if (!crown_art_exists_trx_addons()) {
		?><p><?php echo wp_kses_data(__('<b>Attention!</b> Plugin "ThemeREX Addons is required! Please, install and activate it!', 'crown-art')); ?></p><?php
	}
	?><p><?php
		if (crown_art_get_value_gp('page')!='tgmpa-install-plugins') {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=tgmpa-install-plugins'); ?>" class="button-primary"><i class="dashicons dashicons-admin-plugins"></i> <?php esc_html_e('Install plugins', 'crown-art'); ?></a>
			<?php
		}
		if (function_exists('crown_art_exists_trx_addons') && crown_art_exists_trx_addons()) {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=trx_importer'); ?>" class="button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e('One Click Demo Data', 'crown-art'); ?></a>
			<?php
		}
		?>
        <a href="<?php echo esc_url(admin_url().'customize.php'); ?>" class="button-primary"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Customizer', 'crown-art'); ?></a>
        <a href="#" class="button crown_art_hide_notice"><i class="dashicons dashicons-dismiss"></i> <?php esc_html_e('Hide Notice', 'crown-art'); ?></a>
	</p>
</div>