<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */
?>

<div class="author_info author vcard scheme_dark" itemprop="author" itemscope itemtype="//schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php 
		$crown_art_mult = crown_art_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120*$crown_art_mult ); 
		?>
	</div><!-- .author_avatar -->

	<div class="author_description">
		<h4 class="author_title" itemprop="name"><?php echo wp_kses_data(sprintf(__('About %s', 'crown-art'), '<span class="fn">'.get_the_author().'</span>')); ?></h4>

		<div class="author_bio" itemprop="description">
			<?php echo wp_kses(wpautop(get_the_author_meta( 'description' )), 'crown_art_kses_content'); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

</div><!-- .author_info -->
