<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0.10
 */

$crown_art_footer_scheme =  crown_art_is_inherit(crown_art_get_theme_option('footer_scheme')) ? crown_art_get_theme_option('color_scheme') : crown_art_get_theme_option('footer_scheme');

$crown_art_footer_id = str_replace('footer-custom-', '', crown_art_get_theme_option("footer_style"));

    if ((int) $crown_art_footer_id == 0) {
        $crown_art_footer_id = crown_art_get_post_id(array(
                'name' => $crown_art_footer_id,
                'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
            )
        );
    } else {
        $crown_art_footer_id = apply_filters('trx_addons_filter_get_translated_layout', $crown_art_footer_id);
    }
    
$crown_art_footer_meta = get_post_meta($crown_art_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($crown_art_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($crown_art_footer_id))); 
						if (!empty($crown_art_footer_meta['margin']) != '') 
							echo ' '.esc_attr(crown_art_add_inline_css_class('margin-top: '.esc_attr(crown_art_prepare_css_value($crown_art_footer_meta['margin'])).';'));
						?> scheme_<?php echo esc_attr($crown_art_footer_scheme); 
						?>">
	<?php
    // Custom footer's layout
    do_action('crown_art_action_show_layout', $crown_art_footer_id);
	?>
</footer><!-- /.footer_wrap -->
