<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0.10
 */

// Logo
if (crown_art_is_on(crown_art_get_theme_option('logo_in_footer'))) {
	$crown_art_logo_image = '';
	if (crown_art_get_retina_multiplier(2) > 1)
		$crown_art_logo_image = crown_art_get_theme_option( 'logo_footer_retina' );
	if (empty($crown_art_logo_image)) 
		$crown_art_logo_image = crown_art_get_theme_option( 'logo_footer' );
	$crown_art_logo_text   = get_bloginfo( 'name' );
	if (!empty($crown_art_logo_image) || !empty($crown_art_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($crown_art_logo_image)) {
					$crown_art_attr = crown_art_getimagesize($crown_art_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($crown_art_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('logo', 'crown-art').'"'.(!empty($crown_art_attr[3]) ? sprintf(' %s', $crown_art_attr[3]) : '').'></a>' ;
				} else if (!empty($crown_art_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($crown_art_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>