<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0.10
 */

// Footer sidebar
$crown_art_footer_name = crown_art_get_theme_option('footer_widgets');
$crown_art_footer_present = !crown_art_is_off($crown_art_footer_name) && is_active_sidebar($crown_art_footer_name);
if ($crown_art_footer_present) { 
	crown_art_storage_set('current_sidebar', 'footer');
	$crown_art_footer_wide = crown_art_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($crown_art_footer_name) ) {
		dynamic_sidebar($crown_art_footer_name);
	}
	$crown_art_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($crown_art_out)) {
		$crown_art_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $crown_art_out);
		$crown_art_need_columns = true;	//or check: strpos($crown_art_out, 'columns_wrap')===false;
		if ($crown_art_need_columns) {
			$crown_art_columns = max(0, (int) crown_art_get_theme_option('footer_columns'));
			if ($crown_art_columns == 0) $crown_art_columns = min(4, max(1, substr_count($crown_art_out, '<aside ')));
			if ($crown_art_columns > 1)
				$crown_art_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($crown_art_columns).' widget ', $crown_art_out);
			else
				$crown_art_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($crown_art_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row  sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$crown_art_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($crown_art_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'crown_art_action_before_sidebar' );
				crown_art_show_layout($crown_art_out);
				do_action( 'crown_art_action_after_sidebar' );
				if ($crown_art_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$crown_art_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>