<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_header_css = $crown_art_header_image = '';
$crown_art_header_video = crown_art_get_header_video();
if (true || empty($crown_art_header_video)) {
	$crown_art_header_image = get_header_image();
	if (crown_art_is_on(crown_art_get_theme_option('header_image_override')) && apply_filters('crown_art_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($crown_art_cat_img = crown_art_get_category_image()) != '')
				$crown_art_header_image = $crown_art_cat_img;
		} else if (is_singular() || crown_art_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$crown_art_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($crown_art_header_image)) $crown_art_header_image = $crown_art_header_image[0];
			} else
				$crown_art_header_image = '';
		}
	}
}

?><header class="top_panel top_panel_default<?php
echo !empty($crown_art_header_image) || !empty($crown_art_header_video) ? ' with_bg_image' : ' without_bg_image';
if ($crown_art_header_video!='') echo ' with_bg_video';
if ($crown_art_header_image!='') echo ' '.esc_attr(crown_art_add_inline_css_class('background-image: url('.esc_url($crown_art_header_image).');'));
if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
if (crown_art_is_on(crown_art_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
?> scheme_<?php echo esc_attr(crown_art_is_inherit(crown_art_get_theme_option('header_scheme'))
	? crown_art_get_theme_option('color_scheme')
	: crown_art_get_theme_option('header_scheme'));
?>"><?php

	// Background video
	if (!empty($crown_art_header_video)) {
		get_template_part( 'templates/header-video' );
	}

	// Main menu
	if (crown_art_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Header for single posts
	get_template_part( 'templates/header-single' );

	?></header>