<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_args = get_query_var('crown_art_logo_args');

// Site logo
$crown_art_logo_image  = crown_art_get_logo_image(isset($crown_art_args['type']) ? $crown_art_args['type'] : '');
$crown_art_logo_text   = crown_art_is_on(crown_art_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$crown_art_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($crown_art_logo_image) || !empty($crown_art_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if (!empty($crown_art_logo_image)) {
			$crown_art_attr = crown_art_getimagesize($crown_art_logo_image);
			echo '<img src="'.esc_url($crown_art_logo_image).'" alt="'.esc_attr__('logo', 'crown-art').'"'.(!empty($crown_art_attr[3]) ? sprintf(' %s', $crown_art_attr[3]) : '').'>' ;
		} else {
			crown_art_show_layout(crown_art_prepare_macros($crown_art_logo_text), '<span class="logo_text">', '</span>');
			crown_art_show_layout(crown_art_prepare_macros($crown_art_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>