<?php
/**
 * The template to show mobile menu
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr(crown_art_get_theme_option('menu_mobile_fullscreen') > 0 ? 'fullscreen' : 'narrow'); ?> scheme_dark">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close icon-cancel"></a><?php

		// Logo
		set_query_var('crown_art_logo_args', array('type' => 'inverse'));
		get_template_part( 'templates/header-logo' );
		set_query_var('crown_art_logo_args', array());

		// Mobile menu
		$crown_art_menu_mobile = crown_art_get_nav_menu('menu_mobile');
		if (empty($crown_art_menu_mobile)) {
			$crown_art_menu_mobile = apply_filters('crown_art_filter_get_mobile_menu', '');
			if (empty($crown_art_menu_mobile)) $crown_art_menu_mobile = crown_art_get_nav_menu('menu_main');
			if (empty($crown_art_menu_mobile)) $crown_art_menu_mobile = crown_art_get_nav_menu();
		}
		if (!empty($crown_art_menu_mobile)) {
			if (!empty($crown_art_menu_mobile))
				$crown_art_menu_mobile = str_replace(
					array('menu_main', 'id="menu-', 'sc_layouts_menu_nav', 'sc_layouts_hide_on_mobile', 'hide_on_mobile'),
					array('menu_mobile', 'id="menu_mobile-', '', '', ''),
					$crown_art_menu_mobile
					);
			if (strpos($crown_art_menu_mobile, '<nav ')===false)
				$crown_art_menu_mobile = sprintf('<nav class="menu_mobile_nav_area">%s</nav>', $crown_art_menu_mobile);
			crown_art_show_layout(apply_filters('crown_art_filter_menu_mobile_layout', $crown_art_menu_mobile));
		}

		// Search field
		do_action('crown_art_action_search', 'normal', 'search_mobile', false);
		
		// Social icons
		crown_art_show_layout(crown_art_get_socials_links(), '<div class="socials_mobile">', '</div>');
		?>
	</div>
</div>
