<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

// Page (category, tag, archive, author) title

if ( crown_art_need_page_title() && !is_front_page()) {
	crown_art_sc_layouts_showed('title', true);
	crown_art_sc_layouts_showed('postmeta', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$crown_art_blog_title = crown_art_get_blog_title();
							$crown_art_blog_title_text = $crown_art_blog_title_class = $crown_art_blog_title_link = $crown_art_blog_title_link_text = '';
							if (is_array($crown_art_blog_title)) {
								$crown_art_blog_title_text = $crown_art_blog_title['text'];
								$crown_art_blog_title_class = !empty($crown_art_blog_title['class']) ? ' '.$crown_art_blog_title['class'] : '';
								$crown_art_blog_title_link = !empty($crown_art_blog_title['link']) ? $crown_art_blog_title['link'] : '';
								$crown_art_blog_title_link_text = !empty($crown_art_blog_title['link_text']) ? $crown_art_blog_title['link_text'] : '';
							} else
								$crown_art_blog_title_text = $crown_art_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($crown_art_blog_title_class); ?>"><?php
								$crown_art_top_icon = crown_art_get_category_icon();
								if (!empty($crown_art_top_icon)) {
									$crown_art_attr = crown_art_getimagesize($crown_art_top_icon);
									?><img src="<?php echo esc_url($crown_art_top_icon); ?>" alt="'.esc_attr__('icon', 'crown-art').'" <?php if (!empty($crown_art_attr[3])) crown_art_show_layout($crown_art_attr[3]);?>><?php
								}
								echo wp_kses($crown_art_blog_title_text, 'crown_art_kses_content');
							?></h1>
							<?php
							if (!empty($crown_art_blog_title_link) && !empty($crown_art_blog_title_link_text)) {
								?><a href="<?php echo esc_url($crown_art_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($crown_art_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'crown_art_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>