<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0.14
 */
$crown_art_header_video = crown_art_get_header_video();
$crown_art_embed_video = '';
if (!empty($crown_art_header_video) && !crown_art_is_from_uploads($crown_art_header_video)) {
	if (crown_art_is_youtube_url($crown_art_header_video) && preg_match('/[=\/]([^=\/]*)$/', $crown_art_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$crown_art_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($crown_art_header_video) . '[/embed]' ));
			$crown_art_embed_video = crown_art_make_video_autoplay($crown_art_embed_video);
		} else {
			$crown_art_header_video = str_replace('/watch?v=', '/embed/', $crown_art_header_video);
			$crown_art_header_video = crown_art_add_to_url($crown_art_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url(),
				'widgetid' => 1
			));
			$crown_art_embed_video = '<iframe src="' . esc_url($crown_art_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php crown_art_show_layout($crown_art_embed_video); ?></div><?php
	}
}
?>