<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

// Header sidebar
$crown_art_header_name = crown_art_get_theme_option('header_widgets');
$crown_art_header_present = !crown_art_is_off($crown_art_header_name) && is_active_sidebar($crown_art_header_name);
if ($crown_art_header_present) { 
	crown_art_storage_set('current_sidebar', 'header');
	$crown_art_header_wide = crown_art_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($crown_art_header_name) ) {
		dynamic_sidebar($crown_art_header_name);
	}
	$crown_art_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($crown_art_widgets_output)) {
		$crown_art_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $crown_art_widgets_output);
		$crown_art_need_columns = strpos($crown_art_widgets_output, 'columns_wrap')===false;
		if ($crown_art_need_columns) {
			$crown_art_columns = max(0, (int) crown_art_get_theme_option('header_columns'));
			if ($crown_art_columns == 0) $crown_art_columns = min(6, max(1, substr_count($crown_art_widgets_output, '<aside ')));
			if ($crown_art_columns > 1)
				$crown_art_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($crown_art_columns).' widget ', $crown_art_widgets_output);
			else
				$crown_art_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($crown_art_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$crown_art_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($crown_art_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'crown_art_action_before_sidebar' );
				crown_art_show_layout($crown_art_widgets_output);
				do_action( 'crown_art_action_after_sidebar' );
				if ($crown_art_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$crown_art_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>