<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_link = get_permalink();
$crown_art_post_format = get_post_format();
$crown_art_post_format = empty($crown_art_post_format) ? 'standard' : str_replace('post-format-', '', $crown_art_post_format);
?><div id="post-<?php the_ID(); ?>" 
	<?php post_class( 'related_item related_item_style_2 post_format_'.esc_attr($crown_art_post_format) ); ?>><?php
	crown_art_show_post_featured(array(
		'thumb_size' => crown_art_get_thumb_size( (int) crown_art_get_theme_option('related_posts') == 1 ? 'huge' : 'big' ),
		'show_no_image' => false,
		'singular' => false
		)
	);
	?><div class="post_header entry-header"><?php
		if ( in_array(get_post_type(), array( 'post', 'attachment' ) ) ) {
			?><span class="post_date"><a href="<?php echo esc_url($crown_art_link); ?>"><?php echo crown_art_get_date(); ?></a></span><?php
		}
		?>
		<h6 class="post_title entry-title"><a href="<?php echo esc_url($crown_art_link); ?>"><?php echo the_title(); ?></a></h6>
	</div>
</div>