<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0
 */

$crown_art_post_id    = get_the_ID();
$crown_art_post_date  = crown_art_get_date();
$crown_art_post_title = get_the_title();
$crown_art_post_link  = get_permalink();
$crown_art_post_author_id   = get_the_author_meta('ID');
$crown_art_post_author_name = get_the_author_meta('display_name');
$crown_art_post_author_url  = get_author_posts_url($crown_art_post_author_id, '');

$crown_art_args = get_query_var('crown_art_args_widgets_posts');
$crown_art_show_date = isset($crown_art_args['show_date']) ? (int) $crown_art_args['show_date'] : 1;
$crown_art_show_image = isset($crown_art_args['show_image']) ? (int) $crown_art_args['show_image'] : 1;
$crown_art_show_author = isset($crown_art_args['show_author']) ? (int) $crown_art_args['show_author'] : 1;
$crown_art_show_counters = isset($crown_art_args['show_counters']) ? (int) $crown_art_args['show_counters'] : 1;
$crown_art_show_categories = isset($crown_art_args['show_categories']) ? (int) $crown_art_args['show_categories'] : 1;

$crown_art_output = crown_art_storage_get('crown_art_output_widgets_posts');

$crown_art_post_counters_output = '';
if ( $crown_art_show_counters ) {
	$crown_art_post_counters_output = '<span class="post_info_item post_info_counters">'
								. crown_art_get_post_counters('comments')
							. '</span>';
}


$crown_art_output .= '<article class="post_item with_thumb">';

if ($crown_art_show_image) {
	$crown_art_post_thumb = get_the_post_thumbnail($crown_art_post_id, crown_art_get_thumb_size('tiny'), array(
		'alt' => the_title_attribute( array( 'echo' => false ) )
	));
	if ($crown_art_post_thumb) $crown_art_output .= '<div class="post_thumb">' . ($crown_art_post_link ? '<a href="' . esc_url($crown_art_post_link) . '">' : '') . ($crown_art_post_thumb) . ($crown_art_post_link ? '</a>' : '') . '</div>';
}

$crown_art_output .= '<div class="post_content">'
			. ($crown_art_show_categories 
					? '<div class="post_categories">'
						. crown_art_get_post_categories()
						. $crown_art_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($crown_art_post_link ? '<a href="' . esc_url($crown_art_post_link) . '">' : '') . ($crown_art_post_title) . ($crown_art_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('crown_art_filter_get_post_info', 
								'<div class="post_info">'
									. ($crown_art_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($crown_art_post_link ? '<a href="' . esc_url($crown_art_post_link) . '" class="post_info_date">' : '') 
											. esc_html($crown_art_post_date) 
											. ($crown_art_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($crown_art_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'crown-art') . ' ' 
											. ($crown_art_post_link ? '<a href="' . esc_url($crown_art_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($crown_art_post_author_name) 
											. ($crown_art_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$crown_art_show_categories && $crown_art_post_counters_output
										? $crown_art_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
crown_art_storage_set('crown_art_output_widgets_posts', $crown_art_output);
?>