<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage CROWN_ART
 * @since CROWN_ART 1.0.22
 */

// Theme init priorities:
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
if ( !function_exists('crown_art_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'crown_art_customizer_theme_setup1', 1 );
	function crown_art_customizer_theme_setup1() {
		
		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		crown_art_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Poppins',
				'family' => 'sans-serif',
				'styles' => '300,400,500,600,700'		// Parameter 'style' used only for the Google fonts
				),
            array(
                'name'	 => 'Playfair Display',
                'family' => 'serif',
                'styles' => '400,400i,700,700i'		// Parameter 'style' used only for the Google fonts
            ),
			// Font-face packed with theme
			array(
				'name'   => 'Montserrat',
				'family' => 'sans-serif'
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		crown_art_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		crown_art_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'crown-art'),
				'description'		=> esc_html__('Font settings of the main text of the site', 'crown-art'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1rem',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.929em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0.56px',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.95em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'crown-art'),
				'font-family'		=> 'Playfair Display, serif',
				'font-size' 		=> '4.286em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.185em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '1.66em',
				'margin-bottom'		=> '0.62em'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'crown-art'),
				'font-family'		=> 'Playfair Display, serif',
				'font-size' 		=> '3.429em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.21em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '2.13em',
				'margin-bottom'		=> '0.82em'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'crown-art'),
				'font-family'		=> 'Playfair Display, serif',
				'font-size' 		=> '2.571em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.26em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '2.89em',
				'margin-bottom'		=> '0.97em'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'crown-art'),
				'font-family'		=> 'Playfair Display, serif',
				'font-size' 		=> '1.714em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.3em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '4.5em',
				'margin-bottom'		=> '1.38em'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'crown-art'),
				'font-family'		=> 'Playfair Display, serif',
				'font-size' 		=> '1.286em',
				'font-weight'		=> '700',
				'font-style'		=> 'italic',
				'line-height'		=> '1.7em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.515px',
				'margin-top'		=> '5.95em',
				'margin-bottom'		=> '1.65em'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'crown-art'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.6em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0.57px',
				'margin-top'		=> '7.9em',
				'margin-bottom'		=> '1.7em'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'crown-art'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'crown-art'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1.5em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'crown-art'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0.5px'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'crown-art'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'crown-art'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '13px',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'crown-art'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'crown-art'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.4em',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'crown-art'),
				'description'		=> esc_html__('Font settings of the main menu items', 'crown-art'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0.4px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'crown-art'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'crown-art'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		crown_art_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__('Main', 'crown-art'),
							'description'	=> esc_html__('Colors of the main content area', 'crown-art')
							),
			'alter'	=> array(
							'title'			=> esc_html__('Alter', 'crown-art'),
							'description'	=> esc_html__('Colors of the alternative blocks (sidebars, etc.)', 'crown-art')
							),
			'extra'	=> array(
							'title'			=> esc_html__('Extra', 'crown-art'),
							'description'	=> esc_html__('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'crown-art')
							),
			'inverse' => array(
							'title'			=> esc_html__('Inverse', 'crown-art'),
							'description'	=> esc_html__('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'crown-art')
							),
			'input'	=> array(
							'title'			=> esc_html__('Input', 'crown-art'),
							'description'	=> esc_html__('Colors of the form fields (text field, textarea, select, etc.)', 'crown-art')
							),
			)
		);
		crown_art_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__('Background color', 'crown-art'),
							'description'	=> esc_html__('Background color of this block in the normal state', 'crown-art')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__('Background hover', 'crown-art'),
							'description'	=> esc_html__('Background color of this block in the hovered state', 'crown-art')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__('Border color', 'crown-art'),
							'description'	=> esc_html__('Border color of this block in the normal state', 'crown-art')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__('Border hover', 'crown-art'),
							'description'	=> esc_html__('Border color of this block in the hovered state', 'crown-art')
							),
			'text'		=> array(
							'title'			=> esc_html__('Text', 'crown-art'),
							'description'	=> esc_html__('Color of the plain text inside this block', 'crown-art')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__('Text dark', 'crown-art'),
							'description'	=> esc_html__('Color of the dark text (bold, header, etc.) inside this block', 'crown-art')
							),
			'text_light'=> array(
							'title'			=> esc_html__('Text light', 'crown-art'),
							'description'	=> esc_html__('Color of the light text (post meta, etc.) inside this block', 'crown-art')
							),
			'text_link'	=> array(
							'title'			=> esc_html__('Link', 'crown-art'),
							'description'	=> esc_html__('Color of the links inside this block', 'crown-art')
							),
			'text_hover'=> array(
							'title'			=> esc_html__('Link hover', 'crown-art'),
							'description'	=> esc_html__('Color of the hovered state of links inside this block', 'crown-art')
							),
			'text_link2'=> array(
							'title'			=> esc_html__('Link 2', 'crown-art'),
							'description'	=> esc_html__('Color of the accented texts (areas) inside this block', 'crown-art')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__('Link 2 hover', 'crown-art'),
							'description'	=> esc_html__('Color of the hovered state of accented texts (areas) inside this block', 'crown-art')
							),
			'text_link3'=> array(
							'title'			=> esc_html__('Link 3', 'crown-art'),
							'description'	=> esc_html__('Color of the other accented texts (buttons) inside this block', 'crown-art')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__('Link 3 hover', 'crown-art'),
							'description'	=> esc_html__('Color of the hovered state of other accented texts (buttons) inside this block', 'crown-art')
							)
			)
		);
		crown_art_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'crown-art'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff',   //
					'bd_color'			=> '#e5e5e5',   //line
		
					// Text and links colors
					'text'				=> '#7d7975',   //text
					'text_light'		=> '#b4b2b0',   //post meta
					'text_dark'			=> '#4e4841',   //headers
					'text_link'			=> '#3b97b5',   //link
					'text_hover'		=> '#d05b2d',   //hovers
					'text_link2'		=> '#cf5931',   //button left
					'text_hover2'		=> '#dd7743',   //button right
					'text_link3'		=> '#3797b8',   //button hover left
					'text_hover3'		=> '#73a2a0',   //button hover right
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#fbede2',   //sidebar bg
					'alter_bg_hover'	=> '#f7f7f7',   //
					'alter_bd_color'	=> '#d9d9d9',   //
					'alter_bd_hover'	=> '#e8dbd1',   //
					'alter_text'		=> '#948981',   //
					'alter_light'		=> '#fdf6f1',   //
					'alter_dark'		=> '#2f2b27',   //tooltip bg
					'alter_link'		=> '#febb64',   //inline, quote before
					'alter_hover'		=> '#72cfd5',
					'alter_link2'		=> '#3495b8',   //
					'alter_hover2'		=> '#8be77c',
					'alter_link3'		=> '#e8dad1',   //
					'alter_hover3'		=> '#eec432',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#1e1d22',
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#313131',
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#bfbfbf',
					'extra_light'		=> '#afafaf',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#72cfd5',
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#fbeee3',   //
					'input_bg_hover'	=> '#fbeee3',   //
					'input_bd_color'	=> '#fbeee3',   //
					'input_bd_hover'	=> '#e9d9cc',   //
					'input_text'		=> '#4e4841',   //
					'input_light'		=> '#4e4841',   //
					'input_dark'		=> '#4e4841',   //
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#1d1d1d',
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',   //
					'inverse_hover'		=> '#1d1d1d'
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'crown-art'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#2f2b27',   //
					'bd_color'			=> '#1e1a17',   //
		
					// Text and links colors
					'text'				=> '#ffffff',   //
					'text_light'		=> '#5f5f5f',
					'text_dark'			=> '#ffffff',
                    'text_link'			=> '#3b97b5',   //link
                    'text_hover'		=> '#d05b2d',   //hovers
                    'text_link2'		=> '#cf5931',   //button left
                    'text_hover2'		=> '#dd7743',   //button right
                    'text_link3'		=> '#3797b8',   //button hover left
                    'text_hover3'		=> '#73a2a0',   //button hover right

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#1e1d22',
					'alter_bg_hover'	=> '#28272e',
					'alter_bd_color'	=> '#313131',
					'alter_bd_hover'	=> '#3d3833',   //
					'alter_text'		=> '#a6a6a6',
					'alter_light'		=> '#5f5f5f',
					'alter_dark'		=> '#ffffff',
                    'alter_link'		=> '#febb64',   //inline, quote before
					'alter_hover'		=> '#fe7259',
					'alter_link2'		=> '#80d572',
					'alter_hover2'		=> '#8be77c',
					'alter_link3'		=> '#ddb837',
					'alter_hover3'		=> '#eec432',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#1e1d22',
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#313131',
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#a6a6a6',
					'extra_light'		=> '#5f5f5f',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#ffaa5f',
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#2e2d32',
					'input_bg_hover'	=> '#2e2d32',
					'input_bd_color'	=> '#2e2d32',
					'input_bd_hover'	=> '#353535',
					'input_text'		=> '#b7b7b7',
					'input_light'		=> '#5f5f5f',
					'input_dark'		=> '#ffffff',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#1d1d1d',
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',   //
					'inverse_hover'		=> '#1d1d1d'
				)
			)
		
		));
	}
}

			
// Additional (calculated) theme-specific colors
// Attention! Don't forget setup custom colors also in the theme.customizer.color-scheme.js
if (!function_exists('crown_art_customizer_add_theme_colors')) {
	function crown_art_customizer_add_theme_colors($colors) {
		if (substr($colors['text'], 0, 1) == '#') {
			$colors['bg_color_0']  = crown_art_hex2rgba( $colors['bg_color'], 0 );
			$colors['bg_color_02']  = crown_art_hex2rgba( $colors['bg_color'], 0.2 );
            $colors['bg_color_04']  = crown_art_hex2rgba( $colors['bg_color'], 0.4 );
			$colors['bg_color_07']  = crown_art_hex2rgba( $colors['bg_color'], 0.7 );
			$colors['bg_color_08']  = crown_art_hex2rgba( $colors['bg_color'], 0.8 );
			$colors['bg_color_09']  = crown_art_hex2rgba( $colors['bg_color'], 0.9 );
			$colors['alter_bg_color_07']  = crown_art_hex2rgba( $colors['alter_bg_color'], 0.7 );
			$colors['alter_bg_color_04']  = crown_art_hex2rgba( $colors['alter_bg_color'], 0.4 );
			$colors['alter_bg_color_02']  = crown_art_hex2rgba( $colors['alter_bg_color'], 0.2 );
			$colors['alter_bd_color_02']  = crown_art_hex2rgba( $colors['alter_bd_color'], 0.2 );
			$colors['extra_bg_color_07']  = crown_art_hex2rgba( $colors['extra_bg_color'], 0.7 );
            $colors['text_dark_03']  = crown_art_hex2rgba( $colors['text_dark'], 0.3 );
            $colors['text_dark_05']  = crown_art_hex2rgba( $colors['text_dark'], 0.5 );
			$colors['text_dark_07']  = crown_art_hex2rgba( $colors['text_dark'], 0.7 );
            $colors['text_dark_08']  = crown_art_hex2rgba( $colors['text_dark'], 0.8 );
            $colors['alter_link_02']  = crown_art_hex2rgba( $colors['alter_link'], 0.2 );
            $colors['alter_link_06']  = crown_art_hex2rgba( $colors['alter_link'], 0.6 );
            $colors['inverse_link_065']  = crown_art_hex2rgba( $colors['inverse_link'], 0.65 );
			$colors['text_link_02']  = crown_art_hex2rgba( $colors['text_link'], 0.2 );
			$colors['text_link_07']  = crown_art_hex2rgba( $colors['text_link'], 0.7 );
            $colors['text_hover_08']  = crown_art_hex2rgba( $colors['text_hover'], 0.8 );
			$colors['text_link_blend'] = crown_art_hsb2hex(crown_art_hex2hsb( $colors['text_link'], 2, -5, 5 ));
			$colors['alter_link_blend'] = crown_art_hsb2hex(crown_art_hex2hsb( $colors['alter_link'], 2, -5, 5 ));
		} else {
			$colors['bg_color_0'] = '{{ data.bg_color_0 }}';
			$colors['bg_color_02'] = '{{ data.bg_color_02 }}';
			$colors['bg_color_04'] = '{{ data.bg_color_04 }}';
			$colors['bg_color_07'] = '{{ data.bg_color_07 }}';
			$colors['bg_color_08'] = '{{ data.bg_color_08 }}';
			$colors['bg_color_09'] = '{{ data.bg_color_09 }}';
			$colors['alter_bg_color_07'] = '{{ data.alter_bg_color_07 }}';
			$colors['alter_bg_color_04'] = '{{ data.alter_bg_color_04 }}';
			$colors['alter_bg_color_02'] = '{{ data.alter_bg_color_02 }}';
			$colors['alter_bd_color_02'] = '{{ data.alter_bd_color_02 }}';
			$colors['extra_bg_color_07'] = '{{ data.extra_bg_color_07 }}';
			$colors['text_dark_03'] = '{{ data.text_dark_03 }}';
			$colors['text_dark_05'] = '{{ data.text_dark_05 }}';
			$colors['text_dark_07'] = '{{ data.text_dark_07 }}';
			$colors['text_dark_08'] = '{{ data.text_dark_08 }}';
			$colors['alter_link_02'] = '{{ data.alter_link_02 }}';
			$colors['alter_link_06'] = '{{ data.alter_link_06 }}';
			$colors['inverse_link_065'] = '{{ data.inverse_link_065 }}';
			$colors['text_link_02'] = '{{ data.text_link_02 }}';
			$colors['text_link_07'] = '{{ data.text_link_07 }}';
			$colors['text_hover_08'] = '{{ data.text_hover_08 }}';
			$colors['text_link_blend'] = '{{ data.text_link_blend }}';
			$colors['alter_link_blend'] = '{{ data.alter_link_blend }}';
		}
		return $colors;
	}
}


			
// Additional theme-specific fonts rules
// Attention! Don't forget setup fonts rules also in the theme.customizer.color-scheme.js
if (!function_exists('crown_art_customizer_add_theme_fonts')) {
	function crown_art_customizer_add_theme_fonts($fonts) {
		$rez = array();	
		foreach ($fonts as $tag => $font) {
			if (substr($font['font-family'], 0, 2) != '{{') {
				$rez[$tag.'_font-family'] 		= !empty($font['font-family']) && !crown_art_is_inherit($font['font-family'])
														? 'font-family:' . trim($font['font-family']) . ';' 
														: '';
				$rez[$tag.'_font-size'] 		= !empty($font['font-size']) && !crown_art_is_inherit($font['font-size'])
														? 'font-size:' . crown_art_prepare_css_value($font['font-size']) . ";"
														: '';
				$rez[$tag.'_line-height'] 		= !empty($font['line-height']) && !crown_art_is_inherit($font['line-height'])
														? 'line-height:' . trim($font['line-height']) . ";"
														: '';
				$rez[$tag.'_font-weight'] 		= !empty($font['font-weight']) && !crown_art_is_inherit($font['font-weight'])
														? 'font-weight:' . trim($font['font-weight']) . ";"
														: '';
				$rez[$tag.'_font-style'] 		= !empty($font['font-style']) && !crown_art_is_inherit($font['font-style'])
														? 'font-style:' . trim($font['font-style']) . ";"
														: '';
				$rez[$tag.'_text-decoration'] 	= !empty($font['text-decoration']) && !crown_art_is_inherit($font['text-decoration'])
														? 'text-decoration:' . trim($font['text-decoration']) . ";"
														: '';
				$rez[$tag.'_text-transform'] 	= !empty($font['text-transform']) && !crown_art_is_inherit($font['text-transform'])
														? 'text-transform:' . trim($font['text-transform']) . ";"
														: '';
				$rez[$tag.'_letter-spacing'] 	= !empty($font['letter-spacing']) && !crown_art_is_inherit($font['letter-spacing'])
														? 'letter-spacing:' . trim($font['letter-spacing']) . ";"
														: '';
				$rez[$tag.'_margin-top'] 		= !empty($font['margin-top']) && !crown_art_is_inherit($font['margin-top'])
														? 'margin-top:' . crown_art_prepare_css_value($font['margin-top']) . ";"
														: '';
				$rez[$tag.'_margin-bottom'] 	= !empty($font['margin-bottom']) && !crown_art_is_inherit($font['margin-bottom'])
														? 'margin-bottom:' . crown_art_prepare_css_value($font['margin-bottom']) . ";"
														: '';
			} else {
				$rez[$tag.'_font-family']		= '{{ data["'.$tag.'_font-family"] }}';
				$rez[$tag.'_font-size']			= '{{ data["'.$tag.'_font-size"] }}';
				$rez[$tag.'_line-height']		= '{{ data["'.$tag.'_line-height"] }}';
				$rez[$tag.'_font-weight']		= '{{ data["'.$tag.'_font-weight"] }}';
				$rez[$tag.'_font-style']		= '{{ data["'.$tag.'_font-style"] }}';
				$rez[$tag.'_text-decoration']	= '{{ data["'.$tag.'_text-decoration"] }}';
				$rez[$tag.'_text-transform']	= '{{ data["'.$tag.'_text-transform"] }}';
				$rez[$tag.'_letter-spacing']	= '{{ data["'.$tag.'_letter-spacing"] }}';
				$rez[$tag.'_margin-top']		= '{{ data["'.$tag.'_margin-top"] }}';
				$rez[$tag.'_margin-bottom']		= '{{ data["'.$tag.'_margin-bottom"] }}';
			}
		}
		return $rez;
	}
}

//-------------------------------------------------------
//-- Thumb sizes
//-------------------------------------------------------

if ( !function_exists('crown_art_customizer_theme_setup') ) {
	add_action( 'after_setup_theme', 'crown_art_customizer_theme_setup' );
	function crown_art_customizer_theme_setup() {

		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size(370, 0, false);
		
		// Add thumb sizes
		// ATTENTION! If you change list below - check filter's names in the 'trx_addons_filter_get_thumb_size' hook
		$thumb_sizes = apply_filters('crown_art_filter_add_thumb_sizes', array(
			'crown_art-thumb-huge'		=> array(1540, 820, true),
			'crown_art-thumb-big' 		=> array( 1155, 615, true),
			'crown_art-thumb-med' 		=> array( 740, 464, true),
                'crown_art-thumb-serv' 		=> array( 940, 910, true),
                'crown_art-thumb-team' 		=> array( 740, 740, true),
			'crown_art-thumb-tiny' 		=> array(  200,  200, true),
			'crown_art-thumb-masonry-big' => array( 760,   0, false),		// Only downscale, not crop
			'crown_art-thumb-masonry'		=> array( 370,   0, false),		// Only downscale, not crop
			)
		);
		$mult = crown_art_get_theme_option('retina_ready', 1);
		if ($mult > 1) $GLOBALS['content_width'] = apply_filters( 'crown_art_filter_content_width', 1170*$mult);
		foreach ($thumb_sizes as $k=>$v) {
			// Add Original dimensions
			add_image_size( $k, $v[0], $v[1], $v[2]);
			// Add Retina dimensions
			if ($mult > 1) add_image_size( $k.'-@retina', $v[0]*$mult, $v[1]*$mult, $v[2]);
		}

	}
}

if ( !function_exists('crown_art_customizer_image_sizes') ) {
	add_filter( 'image_size_names_choose', 'crown_art_customizer_image_sizes' );
	function crown_art_customizer_image_sizes( $sizes ) {
		$thumb_sizes = apply_filters('crown_art_filter_add_thumb_sizes', array(
			'crown_art-thumb-huge'		=> esc_html__( 'Fullsize image', 'crown-art' ),
			'crown_art-thumb-big'			=> esc_html__( 'Large image', 'crown-art' ),
			'crown_art-thumb-med'			=> esc_html__( 'Medium image', 'crown-art' ),
			'crown_art-thumb-tiny'		=> esc_html__( 'Small square avatar', 'crown-art' ),
			'crown_art-thumb-masonry-big'	=> esc_html__( 'Masonry Large (scaled)', 'crown-art' ),
			'crown_art-thumb-masonry'		=> esc_html__( 'Masonry (scaled)', 'crown-art' ),
			)
		);
		$mult = crown_art_get_theme_option('retina_ready', 1);
		foreach($thumb_sizes as $k=>$v) {
			$sizes[$k] = $v;
			if ($mult > 1) $sizes[$k.'-@retina'] = $v.' '.esc_html__('@2x', 'crown-art' );
		}
		return $sizes;
	}
}

// Remove some thumb-sizes from the ThemeREX Addons list
if ( !function_exists( 'crown_art_customizer_trx_addons_add_thumb_sizes' ) ) {
	add_filter( 'trx_addons_filter_add_thumb_sizes', 'crown_art_customizer_trx_addons_add_thumb_sizes');
	function crown_art_customizer_trx_addons_add_thumb_sizes($list=array()) {
		if (is_array($list)) {
			foreach ($list as $k=>$v) {
				if (in_array($k, array(
								'trx_addons-thumb-huge',
								'trx_addons-thumb-big',
								'trx_addons-thumb-medium',
								'trx_addons-thumb-tiny',
								'trx_addons-thumb-masonry-big',
								'trx_addons-thumb-masonry',
								)
							)
						) unset($list[$k]);
			}
		}
		return $list;
	}
}

// and replace removed styles with theme-specific thumb size
if ( !function_exists( 'crown_art_customizer_trx_addons_get_thumb_size' ) ) {
	add_filter( 'trx_addons_filter_get_thumb_size', 'crown_art_customizer_trx_addons_get_thumb_size');
	function crown_art_customizer_trx_addons_get_thumb_size($thumb_size='') {
		return str_replace(array(
							'trx_addons-thumb-huge',
							'trx_addons-thumb-huge-@retina',
							'trx_addons-thumb-big',
							'trx_addons-thumb-big-@retina',
							'trx_addons-thumb-medium',
							'trx_addons-thumb-medium-@retina',
                'trx_addons-thumb-serv',
                'trx_addons-thumb-serv-@retina',
                'trx_addons-thumb-team',
                'trx_addons-thumb-team-@retina',
							'trx_addons-thumb-tiny',
							'trx_addons-thumb-tiny-@retina',
							'trx_addons-thumb-masonry-big',
							'trx_addons-thumb-masonry-big-@retina',
							'trx_addons-thumb-masonry',
							'trx_addons-thumb-masonry-@retina',
							),
							array(
							'crown_art-thumb-huge',
							'crown_art-thumb-huge-@retina',
							'crown_art-thumb-big',
							'crown_art-thumb-big-@retina',
							'crown_art-thumb-med',
							'crown_art-thumb-med-@retina',
                                'crown_art-thumb-serv',
                                'crown_art-thumb-serv-@retina',
                                'crown_art-thumb-team',
                                'crown_art-thumb-team-@retina',
							'crown_art-thumb-tiny',
							'crown_art-thumb-tiny-@retina',
							'crown_art-thumb-masonry-big',
							'crown_art-thumb-masonry-big-@retina',
							'crown_art-thumb-masonry',
							'crown_art-thumb-masonry-@retina',
							),
							$thumb_size);
	}
}
?>