<?php
/**
 * The style "default" of the Courses
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_courses');

$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);

if (!empty($args['slider'])) {
	?><div class="swiper-slide"><?php
} else if ((int)$args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}
?>
<div class="sc_courses_item trx_addons_hover trx_addons_hover_style_links">
    <div class="sc_course">
        <?php if (has_post_thumbnail()) { ?>
            <div class="sc_courses_item_thumb">
                <?php the_post_thumbnail( trx_addons_get_thumb_size((int)$args['columns'] > 2 ? 'team' : 'team'), array('alt' => the_title_attribute( array( 'echo' => false ) )) ); ?>
            </div>
        <?php } ?>

        <div class="trx_addons_hover_mask"></div>
        <div class="trx_addons_hover_content">
            <div class="sc_courses_item_info">
                <div class="sc_courses_item_header">
                    <div class="sc_courses_item_meta">
                        <div class="sc_courses_item_meta_item sc_courses_item_meta_date"><?php
                            echo '<span class="course_caption">' . esc_html__('Date', 'crown-art') . ': ' . '</span>';
                            $dt = $meta['date'];
                            echo trim('<span class="sc_courses_item_date">' . date(get_option('date_format'), strtotime($dt)) . '</span>');
                            ?></div>
                            <div class="sc_courses_item_meta_item sc_courses_item_meta_time"><?php echo '<span class="course_caption">' . esc_html__('Time', 'crown-art') . ': '. '</span>' . esc_html($meta['time']); ?></div>
                            <div class="sc_courses_item_price"><?php
                                echo '<span class="course_caption">' . esc_html__('Price', 'crown-art') . ': '. '</span>' . esc_html($meta['price']);
                            ?></div>
                        </div>
                    </div>
                <div class="sc_item_button">
                    <a href="<?php the_permalink($meta['product']); ?>" class="sc_button"><?php esc_html_e('Find out more', 'crown-art'); ?></a>
                </div>
            </div>

        </div>

    </div>
    <h4 class="sc_courses_item_title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

</div>
<?php
if (!empty($args['slider']) || (int)$args['columns'] > 1) {
	?></div><?php
}
?>