<?php
/**
 * The style "default" of the Courses
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_courses');

$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);

if (!empty($args['slider'])) {
	?><div class="swiper-slide"><?php
} else if ((int)$args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}
?>
<div class="sc_courses_item ">
    <div class="sc_course">
        <a href="<?php the_permalink(); ?>">
        <?php if (has_post_thumbnail()) { ?>
            <div class="sc_courses_item_thumb">
                <?php the_post_thumbnail( trx_addons_get_thumb_size((int)$args['columns'] > 2 ? 'medium' : 'big'), array('alt' => the_title_attribute( array( 'echo' => false ) )) ); ?>
            </div>
        <?php } ?>
            <div class="trx_addons_hover_mask"></div>
        </a>
        <span class="sc_courses_item_categories"><?php trx_addons_show_layout(trx_addons_get_post_terms(' ', get_the_ID(), TRX_ADDONS_CPT_COURSES_TAXONOMY)); ?></span>
    </div>

    <div class="sc_courses_content">
        <h4 class="sc_courses_item_title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
        <?php if (!empty($meta['tutor'])) { ?>
            <div class="sc_courses_item_tutor"><?php  echo esc_html($meta['tutor']); ?></div>
        <?php }?>
        <div class="sc_courses_item_info">
            <div class="sc_courses_item_header">
                <div class="sc_courses_item_meta">
                    <div class="sc_courses_item_meta_item sc_courses_item_meta_time"><?php echo '<span class="course_caption">' . esc_html__('Time', 'crown-art') . ': '. '</span>' . esc_html($meta['time']); ?></div>
                    <div class="sc_courses_item_meta_item sc_courses_item_meta_date"><?php
                        echo '<span class="course_caption">' . esc_html__('Days of Week', 'crown-art') . ': ' . '</span>';
                        echo esc_html($meta['duration']);
                        ?></div>
                    <div class="sc_courses_item_price"><?php
                        $price = explode('/', $meta['price']);
                        $currency = '';
                        if ( strpos($price[0] ,'$' ) === 0) {
                            $currency = '<span class="currency">' . esc_html__('$', 'crown-art') . '</span>';
                            $price[0] = substr($price[0], 1);
                            $price[0] = str_replace(' ', '',$price[0]);
                        }
                        echo wp_kses($currency, 'crown_art_kses_content') . esc_html($price[0]) .(!empty($price[1]) ? '<span class="sc_courses_item_period">/'.$price[1].'</span>' : '');
                        ?></div>
                </div>
            </div>
        </div>
    </div>

</div>
<?php
if (!empty($args['slider']) || (int)$args['columns'] > 1) {
	?></div><?php
}
?>