<?php
/**
 * The template to display the team member's page
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

global $TRX_ADDONS_STORAGE;

get_header();

while ( have_posts() ) { the_post();
	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'team_member_page itemscope' ); ?>
		itemscope itemtype="//schema.org/Article">
		
		<?php
		$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);

		// Image
		if ( !trx_addons_sc_layouts_showed('featured') && has_post_thumbnail() ) {
			?><div class="team_member_featured">
				<div class="team_member_avatar">
					<?php
                    crown_art_show_post_featured(array( 'thumb_size' => crown_art_get_thumb_size( strpos(crown_art_get_theme_option('body_style'), 'full')!==false ? 'team' : 'team' ) ));
					?>
				</div>
				<?php			
				if (!empty($meta['socials'])) {
					?><div class="team_member_socials"><?php trx_addons_show_layout(trx_addons_get_socials_links_custom($meta['socials'])); ?></div><?php
				}
				?>
			</div>
			<?php
		}
		
		// Title and Description
		?><div class="team_member_description"><?php
				?><h2 class="team_member_title"><?php the_title(); ?></h2><?php
			?>
			<h6 class="team_member_position"><?php echo esc_html($meta['subtitle']); ?></h6>
			<div class="team_member_details">
				<?php
				$override_options = apply_filters('trx_addons_filter_meta_box_fields', $TRX_ADDONS_STORAGE['meta_box_'.get_post_type()], get_post_type());
				foreach ($override_options as $k=>$v) {
                    if (!empty($v['details']) && !empty($meta[$k]) && ( esc_html($v['title'] != esc_html__('Courses link', 'crown-art')))) {
						?><div class="team_member_details_<?php echo esc_attr($k); ?>"><span class="team_member_details_label"><?php echo esc_html($v['title']); ?>: </span><span class="team_member_details_value"><a href="mailto:<?php echo antispambot($meta[$k]); ?>"><?php echo esc_html($meta[$k]); ?></a>
</span></div><?php
					}
				}
				?>
			</div>
			<?php
			if (!empty($meta['brief_info'])) {
				?>
				<div class="team_member_brief_info">
					<h5 class="team_member_brief_info_title"><?php esc_html_e('Brief info', 'crown-art'); ?></h5>
					<div class="team_member_brief_info_text"><?php echo wpautop($meta['brief_info']); ?></div>
				</div>
				<?php
			}

            foreach ($override_options as $k=>$v) {
                if (!empty($v['details']) && !empty($meta[$k]) && ( esc_html($v['title'] == esc_html__('Courses link', 'crown-art')))) {
                    ?><div class="sc_item_button sc_button_wrap"><a class="sc_button sc_button_size_large" href="<?php echo esc_html($meta[$k]); ?>"><?php the_title(esc_html__('View all courses with', 'crown-art') . ' ');?></a></div><?php
                }
            }
			?>
		</div>
		<?php

		// Post content
		?><div class="team_member_content entry-content" itemprop="articleBody"><?php
			the_content( );
		?></div><!-- .entry-content --><?php

	?></article><?php

	// If comments are open or we have at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) {
		comments_template();
	}
}

get_footer();
?>