<?php

namespace JNews\Elementor\Normal;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
/**
 * JNews FAQ elementor widget class.
 */
class JNewsFAQ extends Widget_Base {
	/**
	 * Get widget name.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'jnewsfaq';
	}
	/**
	 * Get widget title.
	 *
	 * @return string
	 */
	public function get_title() {
		return esc_html__( 'JNews - FAQ ', 'jnews' );
	}
	/**
	 * Get widget icon class.
	 *
	 * @return string
	 */
	public function get_icon() {
		return 'jnews_element_faq';
	}
	/**
	 * Get widget category.
	 *
	 * @return array
	 */
	public function get_categories() {
		return array( 'jnews-element' );
	}
	/**
	 * Register widget controls.
	 *
	 * @return void
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			array(
				'label' => esc_html__( 'FAQ Settings', 'jnews' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'faqLists',
			array(
				'label'       => esc_html__( 'FAQ Lists', 'jnews' ),
				'description' => esc_html__( "List of FAQ item's.", 'jnews' ),
				'type'        => Controls_Manager::REPEATER,
				'default'     => array(
					array(
						'question' => 'Lorem ipsum dolor sit amet',
						'answer'   => 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu',
					),
					array(
						'question' => 'Far far away, behind the word mountains',
						'answer'   => 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu',

					),
					array(
						'question' => 'The quick, brown fox jumps over a lazy dog',
						'answer'   => 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu',

					),
				),
				'fields'      => array(
					array(
						'name'        => 'question',
						'label'       => esc_html__( 'Question', 'jnews' ),
						'description' => esc_html__( 'Insert your FAQ Question.', 'jnews' ),
						'type'        => Controls_Manager::TEXTAREA,
						'default'     => '',
						'label_block' => true,
					),

					array(
						'name'        => 'answer',
						'label'       => esc_html__( 'Answer', 'jnews' ),
						'description' => esc_html__( 'The full answer to the question.', 'jnews' ),
						'type'        => Controls_Manager::WYSIWYG,
						'default'     => '',
						'label_block' => true,
					),
				),
			)
		);

		if ( defined( 'JNEWS_JSONLD' ) ) {
			$this->add_control(
				'hideFrontend',
				array(
					'label'       => esc_html__( 'Hide on Frontend', 'jnews' ),
					'type'        => Controls_Manager::SWITCHER,
					'default'     => false,
					'description' => esc_html__( 'Enable this option if you want this FAQ to appear only on the FAQs Page Schema.', 'jnews' ),
				)
			);
		}

		$this->end_controls_section();

		$this->start_controls_section(
			'section_faq_style',
			array(
				'label' => esc_html__( 'FAQ Style', 'jnews' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'faqStyle',
			array(
				'label'       => esc_html__( 'Style', 'jnews' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'style-1',
				'options'     => array(
					'style-1' => esc_html__( 'Stylle 1', 'jnews' ),
					'style-2' => esc_html__( 'Stylle 2', 'jnews' ),
					'style-3' => esc_html__( 'Stylle 3', 'jnews' ),
					'style-4' => esc_html__( 'Stylle 4', 'jnews' ),
					'style-5' => esc_html__( 'Stylle 5', 'jnews' ),
				),
				'label_block' => true,
				'description' => esc_html__( 'Choose your social icon style.', 'jnews' ),
			)
		);

		$this->add_control(
			'questionColor',
			array(
				'label'     => esc_html__( 'Question Color', 'jnews' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .jnews-faq-wrapper .list-wrapper a.list-toogle h5.question' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'answerColor',
			array(
				'label'     => esc_html__( 'Answer Color', 'jnews' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .jnews-faq-wrapper .list-wrapper .card-expand' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'iconColor',
			array(
				'label'     => esc_html__( 'Icon Color', 'jnews' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .jnews-faq-wrapper .list-wrapper svg.faq-icon path' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'faqBackground',
			array(
				'label'     => esc_html__( 'Background Color', 'jnews' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .jnews-faq-wrapper.style-5 .list-wrapper a.list-toogle, {{WRAPPER}} .jnews-faq-wrapper.style-1 .list-wrapper, {{WRAPPER}} .jnews-faq-wrapper.style-2 .list-wrapper.expand' => 'background: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'faqBorder',
			array(
				'label'     => esc_html__( 'Border Color', 'jnews' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .jnews-faq-wrapper.style-3 .list-wrapper, {{WRAPPER}} .jnews-faq-wrapper.style-4 .list-wrapper' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget method.
	 *
	 * @return void
	 */
	protected function render() {
		$settings      = $this->get_settings();
		$faq_lists     = ! empty( $settings['faqLists'] ) ? $settings['faqLists'] : array();
		$hide_frontend = ! empty( $settings['hideFrontend'] );

		if ( empty( $faq_lists ) ) {
			return;
		}
		add_filter( 'jnews_faq_schema', array( $this, 'merge_faq_schema' ) );

		if ( $hide_frontend ) {
			return;
		}
		$style = ! empty( $settings['faqStyle'] ) ? $settings['faqStyle'] : 'style-1';
		?>
			<div class="jnews-faq-wrapper <?php echo esc_attr( $style ); ?>">
				<?php
				foreach ( $faq_lists as $id => $faq ) :
					$expanded = ( 0 === $id ) ? ' expand' : '';
					$display  = ( 0 === $id ) ? '' : ' style="display: none;"';
					?>
					<div class="list-wrapper<?php echo esc_attr( $expanded ); ?>">
						<a class="list-toogle" href="#">
							<h5 class="question"><?php echo esc_html( $faq['question'] ); ?></h5>
							<svg class="faq-icon" xmlns="http://www.w3.org/2000/svg" width="14" height="8" viewBox="0 0 14 8" fill="none">
								<path d="M13.6152 0.369517C13.3685 0.132903 13.0341 0 12.6855 0C12.3368 0 12.0024 0.132903 11.7557 0.369517L6.98417 4.95184L2.21262 0.369517C1.96321 0.146331 1.63333 0.024827 1.29248 0.0306025C0.951625 0.0363779 0.626413 0.168982 0.385357 0.400478C0.1443 0.631975 0.00621891 0.94429 0.00020504 1.27162C-0.00580883 1.59896 0.120714 1.91576 0.353117 2.15528L6.05442 7.63048C6.30111 7.8671 6.63551 8 6.98417 8C7.33283 8 7.66723 7.8671 7.91392 7.63048L13.6152 2.15528C13.8616 1.91837 14 1.59723 14 1.2624C14 0.927566 13.8616 0.606426 13.6152 0.369517Z" fill="black"/>
							</svg>
						</a>
						<div class="card-expand"<?php echo $display; ?>>
							<?php echo wp_kses_post( $faq['answer'] ); ?>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		<?php
	}
	/**
	 * Content template method on Editor.
	 *
	 * @return void
	 */
	protected function content_template() {
	}
	/**
	 * Get widget script dependency.
	 *
	 * @return array
	 */
	public function get_script_depends() {
		return array( 'jnews-faq-elementor' );
	}
	/**
	 * Get widget style dependency.
	 *
	 * @return array
	 */
	public function get_style_depends() {
		return array( 'jnews-faq' );
	}

	/**
	 * Merge FAQ schema.
	 *
	 * @param array $faq_schema FAQ schema lists.
	 * @return array
	 */
	public function merge_faq_schema( $faq_schema ) {
		$settings = $this->get_settings();
		return array_merge( $faq_schema, $settings['faqLists'] );
	}
}
