<?php
/**
 * @author : Jegtheme
 */
namespace JNews\Module\Element;

use JNews\Module\ModuleOptionAbstract;

/**
 * Faq item option classes.
 */
class Element_Faqitem_Option extends ModuleOptionAbstract {
	/**
	 * Get widget categoriy.
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'JNews - Element', 'jnews' );
	}
	/**
	 * Widget compatible colmn.
	 *
	 * @return array
	 */
	public function compatible_column() {
		return array( 6, 12 );
	}
	/**
	 * Widget Name.
	 *
	 * @return string
	 */
	public function get_module_name() {
		return esc_html__( 'JNews - FAQ Item', 'jnews' );
	}
	/**
	 * Get widget parent.
	 * Only show this widget on parent widget wrapper.
	 *
	 * @return array
	 */
	public function get_module_child() {
		return array( 'only' => 'jnews_element_faqwrapper' );
	}
	/**
	 * Set widget options.
	 *
	 * @return void
	 */
	public function set_options() {
		$this->options[] = array(
			'type'        => 'textarea',
			'param_name'  => 'question',
			'heading'     => esc_html__( 'Question', 'jnews' ),
			'description' => esc_html__( 'Insert your FAQ Question.', 'jnews' ),
		);

		$this->options[] = array(
			'type'        => 'textarea_html',
			'param_name'  => 'content',
			'heading'     => esc_html__( 'answer', 'jnews' ),
			'description' => esc_html__( 'The full answer to the question.', 'jnews' ),
		);
	}
}
