<?php
/**
 * @author : Jegtheme
 */
namespace JNews\Module\Element;

use JNews\Module\ModuleViewAbstract;

/**
 * Faq item class.
 */
class Element_Faqitem_View extends ModuleViewAbstract {
	/**
	 * Faq item view render method
	 *
	 * @param array  $attr Shortcode attributes.
	 * @param string $column_class Column classes.
	 * @return string
	 */
	public function render_module( $attr, $column_class ) {
		global $number_item, $faq_items, $hide_frontend;
		$answer      = wpb_js_remove_wpautop( $this->content, true );
		$faq_items   = is_array( $faq_items ) ? $faq_items : array();
		$faq_items[] = array(
			'question' => $attr['question'],
			'answer'   => $answer,
		);
		if ( $hide_frontend ) {
			return '';
		}
		$wrapper_class = ( 0 === $number_item ) ? 'list-wrapper expand' : 'list-wrapper';
		$card_style    = ( 0 === $number_item ) ? '' : ' style="display: none;"';
		$output        = '
        <div class="' . esc_attr( $wrapper_class ) . '">
            <a class="list-toogle" href="#">
                <h5 class="question">' . esc_html( $attr['question'] ) . '</h5>
                <svg class="faq-icon" xmlns="http://www.w3.org/2000/svg" width="14" height="8" viewBox="0 0 14 8" fill="none">
                    <path d="M13.6152 0.369517C13.3685 0.132903 13.0341 0 12.6855 0C12.3368 0 12.0024 0.132903 11.7557 0.369517L6.98417 4.95184L2.21262 0.369517C1.96321 0.146331 1.63333 0.024827 1.29248 0.0306025C0.951625 0.0363779 0.626413 0.168982 0.385357 0.400478C0.1443 0.631975 0.00621891 0.94429 0.00020504 1.27162C-0.00580883 1.59896 0.120714 1.91576 0.353117 2.15528L6.05442 7.63048C6.30111 7.8671 6.63551 8 6.98417 8C7.33283 8 7.66723 7.8671 7.91392 7.63048L13.6152 2.15528C13.8616 1.91837 14 1.59723 14 1.2624C14 0.927566 13.8616 0.606426 13.6152 0.369517Z" fill="black" />
                </svg>
            </a>
            <div class="card-expand"' . $card_style . '>
                ' . $answer . '
            </div>
        </div>';

		++$number_item;

		return $output;
	}
}
