<?php
/**
 * @author : Jegtheme
 */
namespace JNews\Module\Element;

use JNews\Module\ModuleOptionAbstract;

/**
 * Faq Wraooer option classes.
 */
class Element_Faqwrapper_Option extends ModuleOptionAbstract {
	/**
	 * Get widget categoriy.
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'JNews - Element', 'jnews' );
	}
	/**
	 * Widget compatible colmn.
	 *
	 * @return array
	 */
	public function compatible_column() {
		return array( 8, 12 );
	}
	/**
	 * Widget Name.
	 *
	 * @return string
	 */
	public function get_module_name() {
		return esc_html__( 'JNews - FAQ Wrapper', 'jnews' );
	}
	/**
	 * Get widget parent.
	 * Only show this widget on parent widget wrapper.
	 *
	 * @return array
	 */
	public function get_module_parent() {
		return array( 'only' => 'jnews_element_faqitem' );
	}
	/**
	 * Set widget options.
	 *
	 * @return void
	 */
	public function set_options() {
		$this->get_option();
		$this->set_style_option();
	}
	/**
	 * Set general options.
	 *
	 * @return void
	 */
	public function get_option() {

		if ( defined( 'JNEWS_JSONLD' ) ) {
			$this->options[] = array(
				'type'        => 'checkbox',
				'param_name'  => 'hide_frontend',
				'heading'     => esc_html__( 'Hide on Frontend', 'jnews' ),
				'description' => esc_html__( 'Enable this option if you want this FAQ to appear only on the FAQs Page Schema.', 'jnews' ),

			);
		}
		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'faq_style',
			'heading'     => esc_html__( 'Style', 'jnews' ),
			'description' => esc_html__( 'Choose your social icon style.', 'jnews' ),
			'std'         => 'style-1',
			'value'       => array(
				esc_html__( 'Style 1', 'jnews' ) => 'style-1',
				esc_html__( 'Style 2', 'jnews' ) => 'style-2',
				esc_html__( 'Style 3', 'jnews' ) => 'style-3',
				esc_html__( 'Style 4', 'jnews' ) => 'style-4',
				esc_html__( 'Style 5', 'jnews' ) => 'style-5',
			),
		);

		$this->options[] = array(
			'type'       => 'colorpicker',
			'param_name' => 'question_color',
			'heading'    => esc_html__( 'Question Color', 'jnews' ),
		);

		$this->options[] = array(
			'type'       => 'colorpicker',
			'param_name' => 'answer_color',
			'heading'    => esc_html__( 'Answer Color', 'jnews' ),

		);

		$this->options[] = array(
			'type'       => 'colorpicker',
			'param_name' => 'icon_color',
			'heading'    => esc_html__( 'Icon Color', 'jnews' ),

		);

		$this->options[] = array(
			'type'       => 'colorpicker',
			'param_name' => 'faq_background',
			'heading'    => esc_html__( 'Background Color', 'jnews' ),

		);

		$this->options[] = array(
			'type'       => 'colorpicker',
			'param_name' => 'faq_border',
			'heading'    => esc_html__( 'Border Color', 'jnews' ),

		);
	}
}
