<?php
/**
 * @author : Jegtheme
 */
namespace JNews\Module\Element;

use JNews\Module\ModuleViewAbstract;

/**
 * Faq wrapper class.
 */
class Element_Faqwrapper_View extends ModuleViewAbstract {
	/**
	 * Faq item view render method
	 *
	 * @param array  $attr Shortcode attributes.
	 * @param string $column_class Column classes.
	 * @return string
	 */
	public function render_module( $attr, $column_class ) {
		global $number_item, $hide_frontend;
		$number_item   = 0;
		$hide_frontend = $attr['hide_frontend'];
		$this->load_assets();
		add_filter( 'jnews_faq_schema', array( $this, 'merge_faq_schema' ) );

		return "<div {$this->element_id($attr)} class='jnews-faq-wrapper " . $this->unique_id . ' ' . $attr['faq_style'] . "  {$this->get_vc_class_name()} {$this->color_scheme()} {$attr['el_class']}'>
				    " . ( function_exists( 'wpb_js_remove_wpautop' ) ? wpb_js_remove_wpautop( $this->content ) : do_shortcode( $this->content ) ) . $this->get_faq_styles( $attr ) . '
		    </div>';
	}


	/**
	 * Reguster all assets.
	 *
	 * @return void
	 */
	public function load_assets() {
		wp_enqueue_style(
			'jnews-faq',
			JNEWS_ESSENTIAL_URL . '/assets/css/faq.css',
			array(),
			JNEWS_ESSENTIAL_VERSION,
		);

		wp_enqueue_script(
			'jnews-faq',
			JNEWS_ESSENTIAL_URL . '/assets/js/faq.js',
			array( 'jquery' ),
			JNEWS_ESSENTIAL_VERSION,
			false,
		);
	}

	/**
	 * Get shortcode additional style.
	 *
	 * @param array $atts JNews FAQ shortcode attributes.
	 * @return string
	 */
	private function get_faq_styles( $atts ) {
		$style      = '';
		$element_id = $this->unique_id;

		if ( isset( $atts['faq_background'] ) && ! empty( $atts['faq_background'] ) ) {
			$color  = $atts['faq_background'];
			$style .= ".$element_id.jnews-faq-wrapper.style-5 .list-wrapper a.list-toogle, ";
			$style .= ".$element_id.jnews-faq-wrapper.style-1 .list-wrapper, ";
			$style .= ".$element_id.jnews-faq-wrapper.style-2 .list-wrapper.expand";
			$style .= " {background: $color;}";
		}

		if ( isset( $atts['faq_border'] ) && ! empty( $atts['faq_border'] ) ) {
			$color  = $atts['faq_border'];
			$style .= ".$element_id.jnews-faq-wrapper.style-3 .list-wrapper, ";
			$style .= ".$element_id.jnews-faq-wrapper.style-4 .list-wrapper";
			$style .= " {border-color: $color;}";
		}

		if ( isset( $atts['icon_color'] ) && ! empty( $atts['icon_color'] ) ) {
			$color  = $atts['icon_color'];
			$style .= ".$element_id.jnews-faq-wrapper .list-wrapper svg.faq-icon path";
			$style .= " {fill: $color;}";
		}

		if ( isset( $atts['question_color'] ) && ! empty( $atts['question_color'] ) ) {
			$color  = $atts['question_color'];
			$style .= ".$element_id.jnews-faq-wrapper .list-wrapper a.list-toogle h5.question";
			$style .= " {color: $color;}";
		}

		if ( isset( $atts['answer_color'] ) && ! empty( $atts['answer_color'] ) ) {
			$color  = $atts['answer_color'];
			$style .= ".$element_id.jnews-faq-wrapper .list-wrapper .card-expand";
			$style .= " {color: $color;}";
		}

		if ( ! empty( $style ) ) {
			$style = '<style> ' . $style . ' </style>';
		}

		return $style;
	}

	/**
	 * Merge FAQ schema.
	 *
	 * @param array $faq_schema FAQ schema lists.
	 * @return array
	 */
	public function merge_faq_schema( $faq_schema ) {
		global $faq_items;
		return is_array( $faq_items ) ? array_merge( $faq_schema, $faq_items ) : $faq_schema;
	}
}
