<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings           = array(
  'menu_title'      => constant('KANNI_THEME_NAME').' '.esc_html__('Options', 'kanni'),
  'menu_type'       => 'theme', // menu, submenu, options, theme, etc.
  'menu_slug'       => 'cs-framework',
  'ajax_save'       => true,
  'show_reset_all'  => false,
  'framework_title' => sprintf( esc_html__('Designthemes Framework %sby Designthemes%s', 'kanni'), '<small>', '</small>' )
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options        = array();

$options[]      = array(
  'name'        => 'general',
  'title'       => esc_html__('General', 'kanni'),
  'icon'        => 'fa fa-gears',

  'fields'      => array(

	array(
	  'type'    => 'subheading',
	  'content' => esc_html__( 'General Options', 'kanni' ),
	),
	
	array(
		'id'	=> 'header',
		'type'	=> 'select',
		'title'	=> esc_html__('Site Header', 'kanni'),
		'class'	=> 'chosen',
		'options'	=> 'posts',
		'query_args'	=> array(
			'post_type'	=> 'dt_headers',
			'orderby'	=> 'title',
			'order'	=> 'ASC',
			'posts_per_page' => -1
		),
		'default_option'	=> esc_attr__('Select Header', 'kanni'),
		'attributes'	=> array ( 'style'	=> 'width:50%'),
		'info'	=> esc_html__('Select default header.','kanni'),
	),
	
	array(
		'id'	=> 'footer',
		'type'	=> 'select',
		'title'	=> esc_html__('Site Footer', 'kanni'),
		'class'	=> 'chosen',
		'options'	=> 'posts',
		'query_args'	=> array(
			'post_type'	=> 'dt_footers',
			'orderby'	=> 'title',
			'order'	=> 'ASC',
			'posts_per_page' => -1
		),
		'default_option'	=> esc_attr__('Select Footer', 'kanni'),
		'attributes'	=> array ( 'style'	=> 'width:50%'),
		'info'	=> esc_html__('Select defaultfooter.','kanni'),
	),

	array(
	  'id'  	 => 'use-site-loader',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Site Loader', 'kanni'),
	  'info'	 => esc_html__('YES! to use site loader.', 'kanni')
	),	

	array(
	  'id'  	 => 'show-pagecomments',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Globally Show Page Comments', 'kanni'),
	  'info'	 => esc_html__('YES! to show comments on all the pages. This will globally override your "Allow comments" option under your page "Discussion" settings.', 'kanni'),
	  'default'  => true,
	),

	array(
	  'id'  	 => 'showall-pagination',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Show all pages in Pagination', 'kanni'),
	  'info'	 => esc_html__('YES! to show all the pages instead of dots near the current page.', 'kanni')
	),



	array(
	  'id'      => 'google-map-key',
	  'type'    => 'text',
	  'title'   => esc_html__('Google Map API Key', 'kanni'),
	  'after' 	=> '<p class="cs-text-info">'.esc_html__('Put a valid google account api key here', 'kanni').'</p>',
	),

	array(
	  'id'      => 'mailchimp-key',
	  'type'    => 'text',
	  'title'   => esc_html__('Mailchimp API Key', 'kanni'),
	  'after' 	=> '<p class="cs-text-info">'.esc_html__('Put a valid mailchimp account api key here', 'kanni').'</p>',
	),

  ),
);

$options[]      = array(
  'name'        => 'layout_options',
  'title'       => esc_html__('Layout Options', 'kanni'),
  'icon'        => 'dashicons dashicons-exerpt-view',
  'sections' => array(

	// -----------------------------------------
	// Header Options
	// -----------------------------------------
	array(
	  'name'      => 'breadcrumb_options',
	  'title'     => esc_html__('Breadcrumb Options', 'kanni'),
	  'icon'      => 'fa fa-sitemap',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Breadcrumb Options", 'kanni' ),
		  ),

		  array(
			'id'  		 => 'show-breadcrumb',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Breadcrumb', 'kanni'),
			'info'		 => esc_html__('YES! to display breadcrumb for all pages.', 'kanni'),
			'default' 	 => true,
		  ),

		  array(
			'id'           => 'breadcrumb-delimiter',
			'type'         => 'icon',
			'title'        => esc_html__('Breadcrumb Delimiter', 'kanni'),
			'info'         => esc_html__('Choose delimiter style to display on breadcrumb section.', 'kanni'),
		  ),

		  array(
			'id'           => 'breadcrumb-style',
			'type'         => 'select',
			'title'        => esc_html__('Breadcrumb Style', 'kanni'),
			'options'      => array(
			  'default' 							=> esc_html__('Default', 'kanni'),
			  'aligncenter'    						=> esc_html__('Align Center', 'kanni'),
			  'alignright'  						=> esc_html__('Align Right', 'kanni'),
			  'breadcrumb-left'    					=> esc_html__('Left Side Breadcrumb', 'kanni'),
			  'breadcrumb-right'     				=> esc_html__('Right Side Breadcrumb', 'kanni'),
			  'breadcrumb-top-right-title-center'  	=> esc_html__('Top Right Title Center', 'kanni'),
			  'breadcrumb-top-left-title-center'  	=> esc_html__('Top Left Title Center', 'kanni'),
			),
			'class'        => 'chosen',
			'default'      => 'breadcrumb-right',
			'info'         => esc_html__('Choose alignment style to display on breadcrumb section.', 'kanni'),
		  ),

		  array(
			  'id'                 => 'breadcrumb-position',
			  'type'               => 'select',
			  'title'              => esc_html__('Position', 'kanni' ),
			  'options'            => array(
				  'header-top-absolute'    => esc_html__('Behind the Header','kanni'),
				  'header-top-relative'    => esc_html__('Default','kanni'),
			  ),
			  'class'        => 'chosen',
			  'default'      => 'header-top-relative',
			  'info'         => esc_html__('Choose position of breadcrumb section.', 'kanni'),
		  ),

		  array(
			'id'    => 'breadcrumb_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'kanni'),
			'desc'  => esc_html__('Choose background options for breadcrumb title section.', 'kanni')
		  ),

		),
	),

  ),
);

$options[]      = array(
  'name'        => 'allpage_options',
  'title'       => esc_html__('All Page Options', 'kanni'),
  'icon'        => 'fa fa-files-o',
  'sections' => array(

	// -----------------------------------------
	// Post Options
	// -----------------------------------------
	array(
	  'name'      => 'post_options',
	  'title'     => esc_html__('Post Options', 'kanni'),
	  'icon'      => 'fa fa-file',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Single Post Options", 'kanni' ),
		  ),
		
		  array(
			'id'  		 => 'single-post-authorbox',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Single Author Box', 'kanni'),
			'info'		 => esc_html__('YES! to display author box in single blog posts.', 'kanni')
		  ),

		  array(
			'id'  		 => 'single-post-related',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Single Related Posts', 'kanni'),
			'info'		 => esc_html__('YES! to display related blog posts in single posts.', 'kanni')
		  ),

		  array(
			'id'  		 => 'single-post-navigation',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Single Post Navigation', 'kanni'),
			'info'		 => esc_html__('YES! to display post navigation in single posts.', 'kanni')
		  ),

		  array(
			'id'  		 => 'single-post-comments',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Posts Comments', 'kanni'),
			'info'		 => esc_html__('YES! to display single blog post comments.', 'kanni'),
			'default' 	 => true,
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Post Archives Page Layout", 'kanni' ),
			),
			
		  array(
			'id'      	 => 'post-archives-page-layout',
			'type'       => 'image_select',
			'title'      => esc_html__('Page Layout', 'kanni'),
			'options'    => array(
			  'content-full-width'   => KANNI_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => KANNI_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => KANNI_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => KANNI_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'post-archives-page-layout',
			),
		  ),

		  array(
			'id'  		 => 'show-standard-left-sidebar-for-post-archives',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Standard Left Sidebar', 'kanni'),
			'dependency' => array( 'post-archives-page-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  		 => 'show-standard-right-sidebar-for-post-archives',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Standard Right Sidebar', 'kanni'),
			'dependency' => array( 'post-archives-page-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
			),
			
		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Post Archives Post Layout", 'kanni' ),
		  ),

		  array(
			'id'      	   => 'post-archives-post-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Post Layout', 'kanni'),
			'options'      => array(
			  'one-column' 		  => KANNI_THEME_URI . '/cs-framework-override/images/one-column.png',
			  'one-half-column'   => KANNI_THEME_URI . '/cs-framework-override/images/one-half-column.png',
			  'one-third-column'  => KANNI_THEME_URI . '/cs-framework-override/images/one-third-column.png',
			  '1-2-2'			  => KANNI_THEME_URI . '/cs-framework-override/images/1-2-2.png',
			  '1-2-2-1-2-2' 	  => KANNI_THEME_URI . '/cs-framework-override/images/1-2-2-1-2-2.png',
			  '1-3-3-3'			  => KANNI_THEME_URI . '/cs-framework-override/images/1-3-3-3.png',
			  '1-3-3-3-1' 		  => KANNI_THEME_URI . '/cs-framework-override/images/1-3-3-3-1.png',
			),
			'default'      => 'one-half-column',
		  ),

		  array(
			'id'           => 'post-style',
			'type'         => 'select',
			'title'        => esc_html__('Post Style', 'kanni'),
			'options'      => array(
			  'blog-default-style' 		=> esc_html__('Default', 'kanni'),
			  'entry-date-left'      	=> esc_html__('Date Left', 'kanni'),
			  'entry-date-left outer-frame-border'      	=> esc_html__('Date Left Modern', 'kanni'),
			  'entry-date-author-left'  => esc_html__('Date and Author Left', 'kanni'),
			  'blog-modern-style'       => esc_html__('Modern', 'kanni'),
			  'bordered'      			=> esc_html__('Bordered', 'kanni'),
			  'classic'      			=> esc_html__('Classic', 'kanni'),
			  'entry-overlay-style' 	=> esc_html__('Trendy', 'kanni'),
			  'overlap' 				=> esc_html__('Overlap', 'kanni'),
			  'entry-center-align'		=> esc_html__('Stripe', 'kanni'),
			  'entry-fashion-style'	 	=> esc_html__('Fashion', 'kanni'),
			  'entry-minimal-bordered' 	=> esc_html__('Minimal Bordered', 'kanni'),
			  'blog-medium-style'       => esc_html__('Medium', 'kanni'),
			  'blog-medium-style dt-blog-medium-highlight'     					 => esc_html__('Medium Hightlight', 'kanni'),
			  'blog-medium-style dt-blog-medium-highlight dt-sc-skin-highlight'  => esc_html__('Medium Skin Highlight', 'kanni'),
			),
			'class'        => 'chosen',
			'default'      => 'entry-center-align',
			'info'         => esc_html__('Choose post style to display post archives pages.', 'kanni'),
		  ),

		  array(
			'id'  		 => 'post-archives-enable-excerpt',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Allow Excerpt', 'kanni'),
			'info'		 => esc_html__('YES! to allow excerpt', 'kanni'),
			'default'    => true,
		  ),

		  array(
			'id'  		 => 'post-archives-excerpt',
			'type'  	 => 'number',
			'title' 	 => esc_html__('Excerpt Length', 'kanni'),
			'after'		 => '<span class="cs-text-desc">&nbsp;'.esc_html__('Put Excerpt Length', 'kanni').'</span>',
			'default' 	 => 40,
		  ),

		  array(
			'id'  		 => 'post-archives-enable-readmore',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Read More', 'kanni'),
			'info'		 => esc_html__('YES! to enable read more button', 'kanni'),
			'default'	 => true,
		  ),

		  array(
			'id'  		 => 'post-archives-readmore',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Read More Shortcode', 'kanni'),
			'info'		 => esc_html__('Paste any button shortcode here', 'kanni'),
			'default'	 => '[dt_sc_button title="'.esc_attr__('Read More', 'kanni').'" size="small" /]',
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Single Post & Post Archive options", 'kanni' ),
		  ),

		  array(
			'id'      => 'post-format-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Post Format Meta', 'kanni' ),
			'info'	  => esc_html__('YES! to show post format meta information', 'kanni'),
			'default' => false
		  ),

		  array(
			'id'      => 'post-author-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Author Meta', 'kanni' ),
			'info'	  => esc_html__('YES! to show post author meta information', 'kanni'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-date-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Date Meta', 'kanni' ),
			'info'	  => esc_html__('YES! to show post date meta information', 'kanni'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-comment-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Comment Meta', 'kanni' ),
			'info'	  => esc_html__('YES! to show post comment meta information', 'kanni'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-category-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Category Meta', 'kanni' ),
			'info'	  => esc_html__('YES! to show post category information', 'kanni'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-tag-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Tag Meta', 'kanni' ),
			'info'	  => esc_html__('YES! to show post tag information', 'kanni'),
			'default' => true
			),
			
			array(
				'id'      => 'post-likes',
				'type'    => 'switcher',
				'title'   => esc_html__('Post Likes', 'kanni' ),
				'info'    => esc_html__('YES! to show post likes information', 'kanni'),
				'default' => true
			),

			array(
				'id'      => 'post-views',
				'type'    => 'switcher',
				'title'   => esc_html__('Post Views', 'kanni' ),
				'info'    => esc_html__('YES! to show post views information', 'kanni'),
				'default' => true
			),

		),
	),

	// -----------------------------------------
	// 404 Options
	// -----------------------------------------
	array(
	  'name'      => '404_options',
	  'title'     => esc_html__('404 Options', 'kanni'),
	  'icon'      => 'fa fa-warning',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "404 Message", 'kanni' ),
		  ),
		  
		  array(
			'id'      => 'enable-404message',
			'type'    => 'switcher',
			'title'   => esc_html__('Enable Message', 'kanni' ),
			'info'	  => esc_html__('YES! to enable not-found page message.', 'kanni'),
			'default' => true
		  ),

		  array(
			'id'           => 'notfound-style',
			'type'         => 'select',
			'title'        => esc_html__('Template Style', 'kanni'),
			'options'      => array(
			  'type1' 	   => esc_html__('Modern', 'kanni'),
			  'type2'      => esc_html__('Classic', 'kanni'),
			  'type4'  	   => esc_html__('Diamond', 'kanni'),
			  'type5'      => esc_html__('Shadow', 'kanni'),
			  'type6'      => esc_html__('Diamond Alt', 'kanni'),
			  'type7'  	   => esc_html__('Stack', 'kanni'),
			  'type8'  	   => esc_html__('Minimal', 'kanni'),
			),
			'class'        => 'chosen',
			'default'      => 'type1',
			'info'         => esc_html__('Choose the style of not-found template page.', 'kanni')
		  ),

		  array(
			'id'      => 'notfound-darkbg',
			'type'    => 'switcher',
			'title'   => esc_html__('404 Dark BG', 'kanni' ),
			'info'	  => esc_html__('YES! to use dark bg notfound page for this site.', 'kanni')
		  ),

		  array(
			'id'           => 'notfound-pageid',
			'type'         => 'select',
			'title'        => esc_html__('Custom Page', 'kanni'),
			'options'      => 'pages',
			'class'        => 'chosen',
			'default_option' => esc_html__('Choose the page', 'kanni'),
			'info'       	 => esc_html__('Choose the page for not-found content.', 'kanni')
		  ),
		  
		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Background Options", 'kanni' ),
		  ),

		  array(
			'id'    => 'notfound_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'kanni')
		  ),

		  array(
			'id'  		 => 'notfound-bg-style',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Custom Styles', 'kanni'),
			'info'		 => esc_html__('Paste custom CSS styles for not found page.', 'kanni')
		  ),

		),
	),

	// -----------------------------------------
	// Underconstruction Options
	// -----------------------------------------
	array(
	  'name'      => 'comingsoon_options',
	  'title'     => esc_html__('Under Construction Options', 'kanni'),
	  'icon'      => 'fa fa-thumbs-down',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Under Construction", 'kanni' ),
		  ),
	
		  array(
			'id'      => 'enable-comingsoon',
			'type'    => 'switcher',
			'title'   => esc_html__('Enable Coming Soon', 'kanni' ),
			'info'	  => esc_html__('YES! to check under construction page of your website.', 'kanni')
		  ),
	
		  array(
			'id'           => 'comingsoon-style',
			'type'         => 'select',
			'title'        => esc_html__('Template Style', 'kanni'),
			'options'      => array(
			  'type1' 	   => esc_html__('Diamond', 'kanni'),
			  'type2'      => esc_html__('Teaser', 'kanni'),
			  'type3'  	   => esc_html__('Minimal', 'kanni'),
			  'type4'      => esc_html__('Counter Only', 'kanni'),
			  'type5'      => esc_html__('Belt', 'kanni'),
			  'type6'  	   => esc_html__('Classic', 'kanni'),
			  'type7'  	   => esc_html__('Boxed', 'kanni')
			),
			'class'        => 'chosen',
			'default'      => 'type1',
			'info'         => esc_html__('Choose the style of coming soon template.', 'kanni'),
		  ),

		  array(
			'id'      => 'uc-darkbg',
			'type'    => 'switcher',
			'title'   => esc_html__('Coming Soon Dark BG', 'kanni' ),
			'info'	  => esc_html__('YES! to use dark bg coming soon page for this site.', 'kanni')
		  ),

		  array(
			'id'           => 'comingsoon-pageid',
			'type'         => 'select',
			'title'        => esc_html__('Custom Page', 'kanni'),
			'options'      => 'pages',
			'class'        => 'chosen',
			'default_option' => esc_html__('Choose the page', 'kanni'),
			'info'       	 => esc_html__('Choose the page for comingsoon content.', 'kanni')
		  ),

		  array(
			'id'      => 'show-launchdate',
			'type'    => 'switcher',
			'title'   => esc_html__('Show Launch Date', 'kanni' ),
			'info'	  => esc_html__('YES! to show launch date text.', 'kanni'),
		  ),

		  array(
			'id'      => 'comingsoon-launchdate',
			'type'    => 'text',
			'title'   => esc_html__('Launch Date', 'kanni'),
			'attributes' => array( 
			  'placeholder' => '10/30/2016 12:00:00'
			),
			'after' 	=> '<p class="cs-text-info">'.esc_html__('Put Format: 12/30/2016 12:00:00 month/day/year hour:minute:second', 'kanni').'</p>',
		  ),

		  array(
			'id'           => 'comingsoon-timezone',
			'type'         => 'select',
			'title'        => esc_html__('UTC Timezone', 'kanni'),
			'options'      => array(
			  '-12' => '-12', '-11' => '-11', '-10' => '-10', '-9' => '-9', '-8' => '-8', '-7' => '-7', '-6' => '-6', '-5' => '-5', 
			  '-4' => '-4', '-3' => '-3', '-2' => '-2', '-1' => '-1', '0' => '0', '+1' => '+1', '+2' => '+2', '+3' => '+3', '+4' => '+4',
			  '+5' => '+5', '+6' => '+6', '+7' => '+7', '+8' => '+8', '+9' => '+9', '+10' => '+10', '+11' => '+11', '+12' => '+12'
			),
			'class'        => 'chosen',
			'default'      => '0',
			'info'         => esc_html__('Choose utc timezone, by default UTC:00:00', 'kanni'),
		  ),

		  array(
			'id'    => 'comingsoon_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'kanni')
		  ),

		  array(
			'id'  		 => 'comingsoon-bg-style',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Custom Styles', 'kanni'),
			'info'		 => esc_html__('Paste custom CSS styles for under construction page.', 'kanni'),
		  ),

		),
	),

  ),
);

// -----------------------------------------
// Widget area Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'widgetarea_options',
  'title'       => esc_html__('Widget Area', 'kanni'),
  'icon'        => 'fa fa-trello',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Custom Widget Area for Sidebar", 'kanni' ),
	  ),

	  array(
		'id'           => 'wtitle-style',
		'type'         => 'select',
		'title'        => esc_html__('Sidebar widget Title Style', 'kanni'),
		'options'      => array(
			'default' => esc_html__('Choose any type', 'kanni'),
			'type1'   => esc_html__('Double Border', 'kanni'),
			'type2'   => esc_html__('Tooltip', 'kanni'),
			'type3'   => esc_html__('Title Top Border', 'kanni'),
			'type4'   => esc_html__('Left Border & Pattren', 'kanni'),
			'type5'   => esc_html__('Bottom Border', 'kanni'),
			'type6'   => esc_html__('Tooltip Border', 'kanni'),
			'type7'   => esc_html__('Boxed Modern', 'kanni'),
			'type8'   => esc_html__('Elegant Border', 'kanni'),
			'type9'   => esc_html__('Needle', 'kanni'),
			'type10'  => esc_html__('Ribbon', 'kanni'),
			'type11'  => esc_html__('Content Background', 'kanni'),
			'type12'  => esc_html__('Classic BG', 'kanni'),
			'type13'  => esc_html__('Tiny Boders', 'kanni'),
			'type14'  => esc_html__('BG & Border', 'kanni'),
			'type15'  => esc_html__('Classic BG Alt', 'kanni'),
			'type16'  => esc_html__('Left Border & BG', 'kanni'),
			'type17'  => esc_html__('Basic', 'kanni'),
			'type18'  => esc_html__('BG & Pattern', 'kanni'),
			),
		'class'   => 'chosen',
		'default' =>  'default',
		'info'    => esc_html__('Choose the style of sidebar widget title.', 'kanni')
	  ),

	  array(
		'id'              => 'widgetarea-custom',
		'type'            => 'group',
		'title'           => esc_html__('Custom Widget Area', 'kanni'),
		'button_title'    => esc_html__('Add New', 'kanni'),
		'accordion_title' => esc_html__('Add New Widget Area', 'kanni'),
		'fields'          => array(

		  array(
			'id'          => 'widgetarea-custom-name',
			'type'        => 'text',
			'title'       => esc_html__('Name', 'kanni'),
		  ),

		)
	  ),

	),
);

// -----------------------------------------
// Woocommerce Options
// -----------------------------------------
if( function_exists( 'is_woocommerce' ) && ! class_exists ( 'DTWooPlugin' ) ){

	$options[]      = array(
	  'name'        => 'woocommerce_options',
	  'title'       => esc_html__('Woocommerce', 'kanni'),
	  'icon'        => 'fa fa-shopping-cart',

	  'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Woocommerce Shop Page Options", 'kanni' ),
		  ),

		  array(
			'id'  		 => 'shop-product-per-page',
			'type'  	 => 'number',
			'title' 	 => esc_html__('Products Per Page', 'kanni'),
			'after'		 => '<span class="cs-text-desc">&nbsp;'.esc_html__('Number of products to show in catalog / shop page', 'kanni').'</span>',
			'default' 	 => 12,
		  ),

		  array(
			'id'           => 'product-style',
			'type'         => 'select',
			'title'        => esc_html__('Product Style', 'kanni'),
			'options'      => array(
			  'woo-type1' 	   => esc_html__('Thick Border', 'kanni'),
			  'woo-type4'      => esc_html__('Diamond Icons', 'kanni'),
			  'woo-type8' 	   => esc_html__('Modern', 'kanni'),
			  'woo-type10' 	   => esc_html__('Easing', 'kanni'),
			  'woo-type11' 	   => esc_html__('Boxed', 'kanni'),
			  'woo-type12' 	   => esc_html__('Easing Alt', 'kanni'),
			  'woo-type13' 	   => esc_html__('Parallel', 'kanni'),
			  'woo-type14' 	   => esc_html__('Pointer', 'kanni'),
			  'woo-type16' 	   => esc_html__('Stack', 'kanni'),
			  'woo-type17' 	   => esc_html__('Bouncy', 'kanni'),
			  'woo-type20' 	   => esc_html__('Masked Circle', 'kanni'),
			  'woo-type21' 	   => esc_html__('Classic', 'kanni')
			),
			'class'        => 'chosen',
			'default' 	   => 'woo-type1',
			'info'         => esc_html__('Choose products style to display shop & archive pages.', 'kanni')
		  ),

		  array(
			'id'      	 => 'shop-page-product-layout',
			'type'       => 'image_select',
			'title'      => esc_html__('Product Layout', 'kanni'),
			'options'    => array(
				  1   => KANNI_THEME_URI . '/cs-framework-override/images/one-column.png',
				  2   => KANNI_THEME_URI . '/cs-framework-override/images/one-half-column.png',
				  3   => KANNI_THEME_URI . '/cs-framework-override/images/one-third-column.png',
				  4   => KANNI_THEME_URI . '/cs-framework-override/images/one-fourth-column.png',
			),
			'default'      => 4,
			'attributes'   => array(
			  'data-depend-id' => 'shop-page-product-layout',
			),
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Detail Page Options", 'kanni' ),
		  ),

		  array(
			'id'      	   => 'product-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'kanni'),
			'options'      => array(
			  'content-full-width'   => KANNI_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => KANNI_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => KANNI_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => KANNI_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'kanni'),
			'dependency'   	 => array( 'product-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'kanni'),
			'dependency' 	 => array( 'product-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  		 	 => 'enable-related',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Related Products', 'kanni'),
			'info'	  		 => esc_html__("YES! to display related products on single product's page.", 'kanni')
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Category Page Options", 'kanni' ),
		  ),

		  array(
			'id'      	   => 'product-category-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'kanni'),
			'options'      => array(
			  'content-full-width'   => KANNI_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => KANNI_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => KANNI_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => KANNI_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-category-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-category-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'kanni'),
			'dependency'   	 => array( 'product-category-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-category-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'kanni'),
			'dependency' 	 => array( 'product-category-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),
		  
		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Tag Page Options", 'kanni' ),
		  ),

		  array(
			'id'      	   => 'product-tag-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'kanni'),
			'options'      => array(
			  'content-full-width'   => KANNI_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => KANNI_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => KANNI_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => KANNI_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-tag-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-tag-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'kanni'),
			'dependency'   	 => array( 'product-tag-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-tag-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'kanni'),
			'dependency' 	 => array( 'product-tag-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),

	  ),
	);
}

// -----------------------------------------
// Sociable Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'sociable_options',
  'title'       => esc_html__('Sociable', 'kanni'),
  'icon'        => 'fa fa-share-alt-square',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Sociable", 'kanni' ),
	  ),

	  array(
		'id'              => 'sociable_fields',
		'type'            => 'group',
		'title'           => esc_html__('Sociable', 'kanni'),
		'info'            => esc_html__('Click button to add type of social & url.', 'kanni'),
		'button_title'    => esc_html__('Add New Social', 'kanni'),
		'accordion_title' => esc_html__('Adding New Social Field', 'kanni'),
		'fields'          => array(
		  array(
			'id'          => 'sociable_fields_type',
			'type'        => 'select',
			'title'       => esc_html__('Select Social', 'kanni'),
			'options'      => array(
			  'delicious' 	 => esc_html__('Delicious', 'kanni'),
			  'deviantart' 	 => esc_html__('Deviantart', 'kanni'),
			  'digg' 	  	 => esc_html__('Digg', 'kanni'),
			  'dribbble' 	 => esc_html__('Dribbble', 'kanni'),
			  'envelope' 	 => esc_html__('Envelope', 'kanni'),
			  'facebook' 	 => esc_html__('Facebook', 'kanni'),
			  'flickr' 		 => esc_html__('Flickr', 'kanni'),
			  'google-plus'  => esc_html__('Google Plus', 'kanni'),
			  'gtalk'  		 => esc_html__('GTalk', 'kanni'),
			  'instagram'	 => esc_html__('Instagram', 'kanni'),
			  'lastfm'	 	 => esc_html__('Lastfm', 'kanni'),
			  'linkedin'	 => esc_html__('Linkedin', 'kanni'),
			  'pinterest'	 => esc_html__('Pinterest', 'kanni'),
			  'reddit'		 => esc_html__('Reddit', 'kanni'),
			  'rss'		 	 => esc_html__('RSS', 'kanni'),
			  'skype'		 => esc_html__('Skype', 'kanni'),
			  'stumbleupon'	 => esc_html__('Stumbleupon', 'kanni'),
			  'tumblr'		 => esc_html__('Tumblr', 'kanni'),
			  'twitter'		 => esc_html__('Twitter', 'kanni'),
			  'viadeo'		 => esc_html__('Viadeo', 'kanni'),
			  'vimeo'		 => esc_html__('Vimeo', 'kanni'),
			  'yahoo'		 => esc_html__('Yahoo', 'kanni'),
			  'youtube'		 => esc_html__('Youtube', 'kanni'),
			),
			'class'        => 'chosen',
			'default'      => 'delicious',
		  ),

		  array(
			'id'          => 'sociable_fields_url',
			'type'        => 'text',
			'title'       => esc_html__('Enter URL', 'kanni')
		  ),
		)
	  ),

   ),
);

// -----------------------------------------
// Hook Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'hook_options',
  'title'       => esc_html__('Hooks', 'kanni'),
  'icon'        => 'fa fa-paperclip',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Top Hook", 'kanni' ),
	  ),

	  array(
		'id'  	=> 'enable-top-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Top Hook', 'kanni'),
		'info'	=> esc_html__("YES! to enable top hook.", 'kanni')
	  ),

	  array(
		'id'  		 => 'top-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Top Hook', 'kanni'),
		'info'		 => esc_html__('Paste your top hook, Executes after the opening &lt;body&gt; tag.', 'kanni')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Content Before Hook", 'kanni' ),
	  ),

	  array(
		'id'  	=> 'enable-content-before-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Content Before Hook', 'kanni'),
		'info'	=> esc_html__("YES! to enable content before hook.", 'kanni')
	  ),

	  array(
		'id'  		 => 'content-before-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Content Before Hook', 'kanni'),
		'info'		 => esc_html__('Paste your content before hook, Executes before the opening &lt;#primary&gt; tag.', 'kanni')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Content After Hook", 'kanni' ),
	  ),

	  array(
		'id'  	=> 'enable-content-after-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Content After Hook', 'kanni'),
		'info'	=> esc_html__("YES! to enable content after hook.", 'kanni')
	  ),

	  array(
		'id'  		 => 'content-after-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Content After Hook', 'kanni'),
		'info'		 => esc_html__('Paste your content after hook, Executes after the closing &lt;/#main&gt; tag.', 'kanni')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Bottom Hook", 'kanni' ),
	  ),

	  array(
		'id'  	=> 'enable-bottom-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Bottom Hook', 'kanni'),
		'info'	=> esc_html__("YES! to enable bottom hook.", 'kanni')
	  ),

	  array(
		'id'  		 => 'bottom-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Bottom Hook', 'kanni'),
		'info'		 => esc_html__('Paste your bottom hook, Executes after the closing &lt;/body&gt; tag.', 'kanni')
	  ),
	  
	 array(
		'id'  	=> 'enable-analytics-code',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Tracking Code', 'kanni'),
		'info'	=> esc_html__("YES! to enable site tracking code.", 'kanni')
	  ),

	  array(
		'id'  		 => 'analytics-code',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Google Analytics Tracking Code', 'kanni'),
		'info'		 => esc_html__('Either enter your Google tracking id (UA-XXXXX-X) here. If you want to offer your visitors the option to stop being tracked you can place the shortcode [dt_sc_privacy_google_tracking] somewhere on your site', 'kanni')
	  ),

   ),
);

// -----------------------------------------
// Custom Font Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'font_options',
  'title'       => esc_html__('Custom Fonts', 'kanni'),
  'icon'        => 'fa fa-font',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Custom Fonts", 'kanni' ),
	  ),

	  array(
		'id'              => 'custom_font_fields',
		'type'            => 'group',
		'title'           => esc_html__('Custom Font', 'kanni'),
		'info'            => esc_html__('Click button to add font name & urls.', 'kanni'),
		'button_title'    => esc_html__('Add New Font', 'kanni'),
		'accordion_title' => esc_html__('Adding New Font Field', 'kanni'),
		'fields'          => array(
		  array(
			'id'          => 'custom_font_name',
			'type'        => 'text',
			'title'       => esc_html__('Font Name', 'kanni')
		  ),

		  array(
			'id'      => 'custom_font_woof',
			'type'    => 'upload',
			'title'   => esc_html__('Upload File (*.woff)', 'kanni'),
			'after'   => '<p class="cs-text-muted">'.esc_html__('You can upload custom font family (*.woff) file here.', 'kanni').'</p>',
		  ),

		  array(
			'id'      => 'custom_font_woof2',
			'type'    => 'upload',
			'title'   => esc_html__('Upload File (*.woff2)', 'kanni'),
			'after'   => '<p class="cs-text-muted">'.esc_html__('You can upload custom font family (*.woff2) file here.', 'kanni').'</p>',
		  )
		)
	  ),

   ),
);

// ------------------------------
// backup                       
// ------------------------------
$options[]   = array(
  'name'     => 'backup_section',
  'title'    => esc_html__('Backup', 'kanni'),
  'icon'     => 'fa fa-shield',
  'fields'   => array(

    array(
      'type'    => 'notice',
      'class'   => 'warning',
      'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'kanni')
    ),

    array(
      'type'    => 'backup',
    ),

  )
);

// ------------------------------
// license
// ------------------------------
$options[]   = array(
  'name'     => 'theme_version',
  'title'    => constant('KANNI_THEME_NAME').esc_html__(' Log', 'kanni'),
  'icon'     => 'fa fa-info-circle',
  'fields'   => array(

    array(
      'type'    => 'heading',
      'content' => constant('KANNI_THEME_NAME').esc_html__(' Theme Change Log', 'kanni')
    ),
    array(
      'type'    => 'content',
			'content' => '<pre>

			
2025.09.15 - version 3.5

 *Added: Security Improvements.

2025.08.05 - version 3.4

 *Premium plugins source updated
 *Compatible with the latest version of premium plugins listed

2025.02.18 - version 3.3
 *Premium plugins source updated
 *Compatible with the latest version of premium plugins listed

2024.08.08 - version 3.2
 *Updated: WooCommerce outdated files.
 *Compatible: Latest WordPress and Premium plugins.
 *Updated: WDT Importer source.
 *Fixed: Warnings and Deprecated errors.

2023.12.19 - version 3.1
* Compatible: Latest WordPress and WooCommerce
* Updated: All premium plugins
* Fixed: Design and script issues

2023.11.06 - version 3.0
* Fixed: Unyson plugin installation issue. The source is included in the theme package.
* Compatible: latest version WordPress

2023.08.26 - version 2.9
* Compatible: WordPress 6.3
* Compatible: WooCommerce latest version
* Updated: All premium plugins
* Fixes: Layout design and script issues
* Fixes: Kirki customizer panel design issue

2023.06.09 - version 2.8
* Compatible with WordPress 6.2
* Compatible with PHP 8.2 version
* Updated: All premium plugins
* Resolved PHP warnings and deprecated errors.

2022.12.19 - version 2.7
* Compatible with WordPress 6.1
* Compatible with latest WooCommerce versions
* Compatible with PHP 8.1 version
* Updated: All premium plugins
			
2022.03.02 - version 2.6
* Fixed Kirki Customizer Issue

2021.08.26 - version 2.5
* Compatible with wordpress 5.8

2021.01.22 - version 2.4
* Compatible with wordpress 5.6
* Some design issues updated
* Updated: All premium plugins

2020.11.27 - version 2.3
* Latest jQuery fixes updated
* Updated: All premium plugins

2020.08.13 - version 2.2
* Compatible with wordpress 5.5

2020.08.05 - version 2.1

* Updated: Envato Theme check
* Updated: sanitize_text_field added
* Updated: All wordpress theme standards
* Updated: All premium plugins

2020.06.18 - version 2.0

* Compatible with wordpress 5.4.2
* Updated: Some design tweaks
* Updated: Activating another theme causes error

2020.02.06 - version 1.9

* Updated : All premium plugins			

2020.01.29 - version 1.8

* Compatible with wordpress 5.3.2
* Updated: All premium plugins
* Updated: All wordpress theme standards
* Updated: Privacy and Cookies concept
* Updated: Gutenberg editor support for custom post types

* Fixed: Google Analytics issue
* Fixed: Mailchimp email client issue
* Fixed: Privacy Button Issue
* Fixed: Gutenberg check for old wordpress version

* Improved: Tags taxonomy added for portfolio
* Improved: Single product breadcrumb section
* Improved: Revisions options added for all custom posts
			
2019.11.14 - version 1.7
* Compatible with wordpress 5.2.4
* Updated: All wordpress theme standards
* Updated: All premium plugins			
2019.07.19 - version 1.6
* Compatible with WordPress 5.2.2
* Updated: All premium plugins
* Updated: Revisions added to all custom post types
* Updated: Gutenberg editor support for custom post types
* Updated: Link for phone number module
* Updated: Online documentation link, check readme file

* Fixed: Customizer logo option
* Fixed: Google Analytics issue
* Fixed: Mailchimp email client issue
* Fixed: Gutenberg check for old WordPress version
* Fixed: Edit with Visual Composer for portfolio
* Fixed: Header & Footer wpml option
* Fixed: Smooth scrolling in ie 11
* Fixed: Breadcrumb issue in services page
* Fixed: Privacy popup close button issue
* Fixed: Typhography issue in Gutenberg editor page

* Improved: Single product breadcrumb section
* Improved: Tags taxonomy added for portfolio
* Improved: Woocommerce cart module added with custom class option

* New: Whatsapp Shortcode
* New: Site title color

2019.05.16 - version 1.5
 * Gutenberg Latest update compatible
 * Portfolio Video option
 * Coming Soon page fix
 * Portfolio archive page breadcrumb fix
 * Mega menu image fix
 * GDPR product single page fix
 * Codestar framework update
 * Simple Booking Manager plugin fix
 * Wpml xml file updated
 * disable options for likes and views in single post page
 * Updated latest version of all third party plugins
 * Some design tweaks
 * 
2019.01.19 - version 1.4
 * Gutenberg compatible
 * Latest WordPress version 5.0.3 compatible
 * Updated latest version of all third party plugins
 * Some design tweaks
       
2018.10.29 - version 1.3
 * Small bug fix.
2018.10.10 - version 1.2
 * Gutenberg plugin compatible
 * GDPR Compliant update in comment form, mailchimp form etc.
 * Updated documentation.
 * Updated WPBakery Page Builder plugin.
 * Updated Ultimate Addons for WPBakery Page Builder.
 
2018.08.28 - version 1.1
 * Unyson Demo Content Updated

2018.08.10 - version 1.0
 * First release!  </pre>',
    ),

  )
);

// ------------------------------
// Seperator
// ------------------------------
$options[] = array(
  'name'   => 'seperator_1',
  'title'  => esc_html__('Plugin Options', 'kanni'),
  'icon'   => 'fa fa-plug'
);


CSFramework::instance( $settings, $options );