<?php
/**
 * Theme Functions
 *
 * @package DTtheme
 * @author DesignThemes
 * @link http://wedesignthemes.com
 */
define( 'KANNI_THEME_DIR', get_template_directory() );
define( 'KANNI_THEME_URI', get_template_directory_uri() );
define( 'KANNI_CORE_PLUGIN', WP_PLUGIN_DIR.'/designthemes-core-features' );

 if ( ! defined( 'THEME_SUPPORT_DOMAIN' ) ) {
            define( 'THEME_SUPPORT_DOMAIN', 'https://themessupport.com' );
        }
        if ( ! defined( 'PLUGIN_ENDPOINT_PATH' ) ) {
            define( 'PLUGIN_ENDPOINT_PATH', '/plugin-server/plugins-version.php' );
        }

if (function_exists ('wp_get_theme')) :
	$themeData = wp_get_theme();
	define( 'KANNI_THEME_NAME', $themeData->get('Name'));
	define( 'KANNI_THEME_VERSION', $themeData->get('Version'));
endif;

/* ---------------------------------------------------------------------------
 * Loads Kirki
 * ---------------------------------------------------------------------------*/
require_once( KANNI_THEME_DIR .'/kirki/index.php' );

/* ---------------------------------------------------------------------------
 * Loads Codestar
 * ---------------------------------------------------------------------------*/
require_once KANNI_THEME_DIR .'/cs-framework/cs-framework.php';

if( !defined( 'CS_ACTIVE_TAXONOMY' ) ) { define( 'CS_ACTIVE_TAXONOMY',   false ); }
if( !defined( 'CS_ACTIVE_SHORTCODE' ) ) { define( 'CS_ACTIVE_SHORTCODE',  false ); }
if( !defined( 'CS_ACTIVE_CUSTOMIZE' ) ) { define( 'CS_ACTIVE_CUSTOMIZE',  false ); }

/* ---------------------------------------------------------------------------
 * Create function to get theme options
 * --------------------------------------------------------------------------- */
function kanni_cs_get_option($key, $value = '') {

	$v = cs_get_option( $key );

	if ( !empty( $v ) ) {
		return $v;
	} else {
		return $value;
	}
}

/* ---------------------------------------------------------------------------
 * Loads Theme Textdomain
 * ---------------------------------------------------------------------------*/ 
define( 'KANNI_LANG_DIR', KANNI_THEME_DIR. '/languages' );
load_theme_textdomain( 'kanni', KANNI_LANG_DIR );

/* ---------------------------------------------------------------------------
 * Loads the Admin Panel Style
 * ---------------------------------------------------------------------------*/
function kanni_admin_scripts() {
	wp_enqueue_style('kanni-admin', KANNI_THEME_URI .'/cs-framework-override/style.css');
}
add_action( 'admin_enqueue_scripts', 'kanni_admin_scripts' );

/* ---------------------------------------------------------------------------
 * Loads Theme Functions
 * ---------------------------------------------------------------------------*/

// Functions --------------------------------------------------------------------
require_once( KANNI_THEME_DIR .'/framework/register-functions.php' );

// Header -----------------------------------------------------------------------
require_once( KANNI_THEME_DIR .'/framework/register-head.php' );

// Hooks ------------------------------------------------------------------------
require_once( KANNI_THEME_DIR .'/framework/register-hooks.php' );

// Post Functions ---------------------------------------------------------------
require_once( KANNI_THEME_DIR .'/framework/register-post-functions.php' );
new kanni_post_functions;

// Widgets ----------------------------------------------------------------------
add_action( 'widgets_init', 'kanni_widgets_init' );
function kanni_widgets_init() {
	require_once( KANNI_THEME_DIR .'/framework/register-widgets.php' );
}

// Plugins ---------------------------------------------------------------------- 
require_once( KANNI_THEME_DIR .'/framework/register-plugins.php' );

// WooCommerce ------------------------------------------------------------------
if( function_exists( 'is_woocommerce' ) && ! class_exists ( 'DTWooPlugin' ) ){
	require_once( KANNI_THEME_DIR .'/framework/register-woocommerce.php' );
}

// WP Store Locator -------------------------------------------------------------
if( class_exists( 'WP_Store_locator' ) ){
	require_once( KANNI_THEME_DIR .'/framework/register-storelocator.php' );
}

// Register Gutenberg -----------------------------------------------------------
require_once( KANNI_THEME_DIR .'/framework/register-gutenberg-editor.php' );