<?php
function kanni_kirki_config() {
	return 'kanni_kirki_config';
}

function kanni_defaults( $key = '' ) {
	$defaults = array();

	# site identify
	$defaults['use-custom-logo'] = '1';
	$defaults['custom-logo'] = KANNI_THEME_URI.'/images/logo.png';
	$defaults['custom-light-logo'] = KANNI_THEME_URI.'/images/light-logo.png';
	$defaults['site_icon'] = KANNI_THEME_URI.'/images/favicon.ico';
	$defaults['custom-title-color'] = '#222222';

	# site layout
	$defaults['site-layout'] = 'wide';

	# site skin
	$defaults['primary-color'] 		= '#85c226';
	$defaults['secondary-color'] 	= '#4b740b';
	$defaults['tertiary-color'] 	= '#6a9b21';
	$defaults['body-bg-color']      = '#ffffff';
	$defaults['body-content-color'] = '#222222';
	$defaults['body-a-color']       = '#85c226';
	$defaults['body-a-hover-color'] = '#222222';	

	# site breadcrumb
	$defaults['customize-breadcrumb-title-typo'] = '1';
	$defaults['breadcrumb-title-typo'] = array( 'font-family' => 'Rajdhani',
		'variant' => '700',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '54px',
		'line-height' => '',
		'letter-spacing' => '0px',
		'color' => '#FFFFFF',
		'text-align' => 'unset',
		'text-transform' => 'none' );
	$defaults['customize-breadcrumb-typo'] = '0px';
	$defaults['breadcrumb-typo'] = array( 'font-family' => 'Lato',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '14px',
		'line-height' => '',
		'letter-spacing' => '0px',
		'color' => '#FFFFFF',
		'text-align' => 'unset',
		'text-transform' => 'none' );

	# site footer
	$defaults['customize-footer-title-typo'] = '1';
	$defaults['footer-title-typo'] = array( 'font-family' => 'Rajdhani',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '24px',
		'line-height' => '36px',
		'letter-spacing' => '0px',
		'color' => '#2b2b2b',
		'text-align' => 'left',
		'text-transform' => 'none' );
	$defaults['customize-footer-content-typo'] = '1';
	$defaults['footer-content-typo'] = array( 'font-family' => 'Lato',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '16px',
		'line-height' => '26px',
		'letter-spacing' => '0px',
		'color' => '#333333',
		'text-align' => 'left',
		'text-transform' => 'none' );

	# site typography
	$defaults['customize-body-h1-typo'] = '1';
	$defaults['h1'] = array(
		'font-family' => 'Rajdhani',
		'variant' => '700',
		'font-size' => '44px',
		'line-height' => '',
		'letter-spacing' => '0px',
		'color' => '#222222',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h2-typo'] = '1';
	$defaults['h2'] = array(
		'font-family' => 'Rajdhani',
		'variant' => '700',
		'font-size' => '42px',
		'line-height' => '',
		'letter-spacing' => '0px',
		'color' => '#222222',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h3-typo'] = '1';
	$defaults['h3'] = array(
		'font-family' => 'Rajdhani',
		'variant' => '700',
		'font-size' => '40px',
		'line-height' => '',
		'letter-spacing' => '0px',
		'color' => '#222222',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h4-typo'] = '1';
	$defaults['h4'] = array(
		'font-family' => 'Rajdhani',
		'variant' => '700',
		'font-size' => '34px',
		'line-height' => '',
		'letter-spacing' => '0px',
		'color' => '#222222',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h5-typo'] = '1';
	$defaults['h5'] = array(
		'font-family' => 'Rajdhani',
		'variant' => '700',
		'font-size' => '28px',
		'line-height' => '',
		'letter-spacing' => '0px',
		'color' => '#222222',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h6-typo'] = '1';
	$defaults['h6'] = array(
		'font-family' => 'Rajdhani',
		'variant' => '700',
		'font-size' => '20px',
		'line-height' => '',
		'letter-spacing' => '0px',
		'color' => '#222222',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-content-typo'] = '1';
	$defaults['body-content-typo'] = array(
		'font-family' => 'Lato',
		'variant' => 'normal',
		'font-size' => '16px',
		'line-height' => '26px',
		'letter-spacing' => '',
		'color' => '#222222',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['footer-content-a-color'] = '';
	$defaults['footer-content-a-hover-color'] = '';	

	if( !empty( $key ) && array_key_exists( $key, $defaults) ) {
		return $defaults[$key];
	}

	return '';
}

function kanni_image_positions() {

	$positions = array( "top left" => esc_attr__('Top Left','kanni'),
		"top center"    => esc_attr__('Top Center','kanni'),
		"top right"     => esc_attr__('Top Right','kanni'),
		"center left"   => esc_attr__('Center Left','kanni'),
		"center center" => esc_attr__('Center Center','kanni'),
		"center right"  => esc_attr__('Center Right','kanni'),
		"bottom left"   => esc_attr__('Bottom Left','kanni'),
		"bottom center" => esc_attr__('Bottom Center','kanni'),
		"bottom right"  => esc_attr__('Bottom Right','kanni'),
	);

	return $positions;
}

function kanni_image_repeats() {

	$image_repeats = array( "repeat" => esc_attr__('Repeat','kanni'),
		"repeat-x"  => esc_attr__('Repeat in X-axis','kanni'),
		"repeat-y"  => esc_attr__('Repeat in Y-axis','kanni'),
		"no-repeat" => esc_attr__('No Repeat','kanni')
	);

	return $image_repeats;
}

function kanni_border_styles() {

	$image_repeats = array(
		"none"	 => esc_attr__('None','kanni'),
		"dotted" => esc_attr__('Dotted','kanni'),
		"dashed" => esc_attr__('Dashed','kanni'),
		"solid"	 => esc_attr__('Solid','kanni'),
		"double" => esc_attr__('Double','kanni'),
		"groove" => esc_attr__('Groove','kanni'),
		"ridge"	 => esc_attr__('Ridge','kanni'),
	);

	return $image_repeats;
}

function kanni_animations() {

	$animations = array(
		'' 					 => esc_html__('Default','kanni'),	
		"bigEntrance"        =>  esc_attr__("bigEntrance",'kanni'),
        "bounce"             =>  esc_attr__("bounce",'kanni'),
        "bounceIn"           =>  esc_attr__("bounceIn",'kanni'),
        "bounceInDown"       =>  esc_attr__("bounceInDown",'kanni'),
        "bounceInLeft"       =>  esc_attr__("bounceInLeft",'kanni'),
        "bounceInRight"      =>  esc_attr__("bounceInRight",'kanni'),
        "bounceInUp"         =>  esc_attr__("bounceInUp",'kanni'),
        "bounceOut"          =>  esc_attr__("bounceOut",'kanni'),
        "bounceOutDown"      =>  esc_attr__("bounceOutDown",'kanni'),
        "bounceOutLeft"      =>  esc_attr__("bounceOutLeft",'kanni'),
        "bounceOutRight"     =>  esc_attr__("bounceOutRight",'kanni'),
        "bounceOutUp"        =>  esc_attr__("bounceOutUp",'kanni'),
        "expandOpen"         =>  esc_attr__("expandOpen",'kanni'),
        "expandUp"           =>  esc_attr__("expandUp",'kanni'),
        "fadeIn"             =>  esc_attr__("fadeIn",'kanni'),
        "fadeInDown"         =>  esc_attr__("fadeInDown",'kanni'),
        "fadeInDownBig"      =>  esc_attr__("fadeInDownBig",'kanni'),
        "fadeInLeft"         =>  esc_attr__("fadeInLeft",'kanni'),
        "fadeInLeftBig"      =>  esc_attr__("fadeInLeftBig",'kanni'),
        "fadeInRight"        =>  esc_attr__("fadeInRight",'kanni'),
        "fadeInRightBig"     =>  esc_attr__("fadeInRightBig",'kanni'),
        "fadeInUp"           =>  esc_attr__("fadeInUp",'kanni'),
        "fadeInUpBig"        =>  esc_attr__("fadeInUpBig",'kanni'),
        "fadeOut"            =>  esc_attr__("fadeOut",'kanni'),
        "fadeOutDownBig"     =>  esc_attr__("fadeOutDownBig",'kanni'),
        "fadeOutLeft"        =>  esc_attr__("fadeOutLeft",'kanni'),
        "fadeOutLeftBig"     =>  esc_attr__("fadeOutLeftBig",'kanni'),
        "fadeOutRight"       =>  esc_attr__("fadeOutRight",'kanni'),
        "fadeOutUp"          =>  esc_attr__("fadeOutUp",'kanni'),
        "fadeOutUpBig"       =>  esc_attr__("fadeOutUpBig",'kanni'),
        "flash"              =>  esc_attr__("flash",'kanni'),
        "flip"               =>  esc_attr__("flip",'kanni'),
        "flipInX"            =>  esc_attr__("flipInX",'kanni'),
        "flipInY"            =>  esc_attr__("flipInY",'kanni'),
        "flipOutX"           =>  esc_attr__("flipOutX",'kanni'),
        "flipOutY"           =>  esc_attr__("flipOutY",'kanni'),
        "floating"           =>  esc_attr__("floating",'kanni'),
        "hatch"              =>  esc_attr__("hatch",'kanni'),
        "hinge"              =>  esc_attr__("hinge",'kanni'),
        "lightSpeedIn"       =>  esc_attr__("lightSpeedIn",'kanni'),
        "lightSpeedOut"      =>  esc_attr__("lightSpeedOut",'kanni'),
        "pullDown"           =>  esc_attr__("pullDown",'kanni'),
        "pullUp"             =>  esc_attr__("pullUp",'kanni'),
        "pulse"              =>  esc_attr__("pulse",'kanni'),
        "rollIn"             =>  esc_attr__("rollIn",'kanni'),
        "rollOut"            =>  esc_attr__("rollOut",'kanni'),
        "rotateIn"           =>  esc_attr__("rotateIn",'kanni'),
        "rotateInDownLeft"   =>  esc_attr__("rotateInDownLeft",'kanni'),
        "rotateInDownRight"  =>  esc_attr__("rotateInDownRight",'kanni'),
        "rotateInUpLeft"     =>  esc_attr__("rotateInUpLeft",'kanni'),
        "rotateInUpRight"    =>  esc_attr__("rotateInUpRight",'kanni'),
        "rotateOut"          =>  esc_attr__("rotateOut",'kanni'),
        "rotateOutDownRight" =>  esc_attr__("rotateOutDownRight",'kanni'),
        "rotateOutUpLeft"    =>  esc_attr__("rotateOutUpLeft",'kanni'),
        "rotateOutUpRight"   =>  esc_attr__("rotateOutUpRight",'kanni'),
        "shake"              =>  esc_attr__("shake",'kanni'),
        "slideDown"          =>  esc_attr__("slideDown",'kanni'),
        "slideExpandUp"      =>  esc_attr__("slideExpandUp",'kanni'),
        "slideLeft"          =>  esc_attr__("slideLeft",'kanni'),
        "slideRight"         =>  esc_attr__("slideRight",'kanni'),
        "slideUp"            =>  esc_attr__("slideUp",'kanni'),
        "stretchLeft"        =>  esc_attr__("stretchLeft",'kanni'),
        "stretchRight"       =>  esc_attr__("stretchRight",'kanni'),
        "swing"              =>  esc_attr__("swing",'kanni'),
        "tada"               =>  esc_attr__("tada",'kanni'),
        "tossing"            =>  esc_attr__("tossing",'kanni'),
        "wobble"             =>  esc_attr__("wobble",'kanni'),
        "fadeOutDown"        =>  esc_attr__("fadeOutDown",'kanni'),
        "fadeOutRightBig"    =>  esc_attr__("fadeOutRightBig",'kanni'),
        "rotateOutDownLeft"  =>  esc_attr__("rotateOutDownLeft",'kanni')
    );

	return $animations;
}

function kanni_custom_fonts( $standard_fonts ){

	$custom_fonts = array();

	$fonts = cs_get_option('custom_font_fields');
	if( is_countable( $fonts ) && count( $fonts ) > 0 ):
		foreach( $fonts as $font ):
			$custom_fonts[$font['custom_font_name']] = array(
				'label' => $font['custom_font_name'],
				'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
				'stack' => $font['custom_font_name'] . ', sans-serif'
			);
		endforeach;
	endif;

	return array_merge_recursive( $custom_fonts, $standard_fonts );
}
add_filter( 'kirki/fonts/standard_fonts', 'kanni_custom_fonts', 20 );